"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setDefaultProfileAdHocDataViews = exports.setDataView = exports.setAdHocDataViews = exports.replaceAdHocDataViewWithId = exports.appendAdHocDataViews = void 0;
var _lodash = require("lodash");
var _internal_state = require("../internal_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const setDataView = dataView => (dispatch, _, {
  runtimeStateManager
}) => {
  dispatch(_internal_state.internalStateSlice.actions.setDataViewId(dataView.id));
  runtimeStateManager.currentDataView$.next(dataView);
};
exports.setDataView = setDataView;
const setAdHocDataViews = adHocDataViews => (_, __, {
  runtimeStateManager
}) => {
  runtimeStateManager.adHocDataViews$.next(adHocDataViews);
};
exports.setAdHocDataViews = setAdHocDataViews;
const setDefaultProfileAdHocDataViews = defaultProfileAdHocDataViews => (dispatch, getState, {
  runtimeStateManager
}) => {
  const prevAdHocDataViews = runtimeStateManager.adHocDataViews$.getValue();
  const prevState = getState();
  const adHocDataViews = prevAdHocDataViews.filter(dataView => !prevState.defaultProfileAdHocDataViewIds.includes(dataView.id)).concat(defaultProfileAdHocDataViews);
  const defaultProfileAdHocDataViewIds = defaultProfileAdHocDataViews.map(dataView => dataView.id);
  dispatch(setAdHocDataViews(adHocDataViews));
  dispatch(_internal_state.internalStateSlice.actions.setDefaultProfileAdHocDataViewIds(defaultProfileAdHocDataViewIds));
};
exports.setDefaultProfileAdHocDataViews = setDefaultProfileAdHocDataViews;
const appendAdHocDataViews = dataViewsAdHoc => (dispatch, _, {
  runtimeStateManager
}) => {
  const prevAdHocDataViews = runtimeStateManager.adHocDataViews$.getValue();
  const newDataViews = Array.isArray(dataViewsAdHoc) ? dataViewsAdHoc : [dataViewsAdHoc];
  const existingDataViews = (0, _lodash.differenceBy)(prevAdHocDataViews, newDataViews, 'id');
  dispatch(setAdHocDataViews(existingDataViews.concat(newDataViews)));
};
exports.appendAdHocDataViews = appendAdHocDataViews;
const replaceAdHocDataViewWithId = (prevId, newDataView) => (dispatch, getState, {
  runtimeStateManager
}) => {
  const prevAdHocDataViews = runtimeStateManager.adHocDataViews$.getValue();
  let defaultProfileAdHocDataViewIds = getState().defaultProfileAdHocDataViewIds;
  if (defaultProfileAdHocDataViewIds.includes(prevId)) {
    defaultProfileAdHocDataViewIds = defaultProfileAdHocDataViewIds.map(id => id === prevId ? newDataView.id : id);
  }
  dispatch(setAdHocDataViews(prevAdHocDataViews.map(dataView => dataView.id === prevId ? newDataView : dataView)));
  dispatch(_internal_state.internalStateSlice.actions.setDefaultProfileAdHocDataViewIds(defaultProfileAdHocDataViewIds));
};
exports.replaceAdHocDataViewWithId = replaceAdHocDataViewWithId;