"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTopNavLinks = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _esqlUtils = require("@kbn/esql-utils");
var _discoverUtils = require("@kbn/discover-utils");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _constants = require("../../../../../common/constants");
var _on_save_search = require("./on_save_search");
var _app_menu_actions = require("./app_menu_actions");
var _context_awareness = require("../../../../context_awareness");
var _redux = require("../../state_management/redux");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Helper function to build the top nav links
 */
const useTopNavLinks = ({
  dataView,
  services,
  state,
  onOpenInspector,
  isEsqlMode,
  adHocDataViews,
  topNavCustomization,
  shouldShowESQLToDataViewTransitionModal,
  hasShareIntegration
}) => {
  var _defaultMenu$saveItem2;
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const [newSearchUrl, setNewSearchUrl] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const fetchData = async () => {
      const url = await services.locator.getUrl({});
      setNewSearchUrl(url);
    };
    fetchData();
  }, [services]);
  const {
    authorizedRuleTypes
  } = (0, _alertsUiShared.useGetRuleTypesPermissions)({
    http: services.http,
    toasts: services.notifications.toasts
  });
  const getAuthorizedWriteConsumerIds = ruleTypes => ruleTypes.filter(ruleType => Object.values(ruleType.authorizedConsumers).some(consumer => consumer.all)).map(ruleType => ruleType.id);
  const discoverParams = (0, _react.useMemo)(() => ({
    isEsqlMode,
    dataView,
    adHocDataViews,
    authorizedRuleTypeIds: getAuthorizedWriteConsumerIds(authorizedRuleTypes),
    onUpdateAdHocDataViews: async adHocDataViewList => {
      await state.actions.loadDataViewList();
      dispatch(_redux.internalStateActions.setAdHocDataViews(adHocDataViewList));
    }
  }), [isEsqlMode, dataView, adHocDataViews, dispatch, authorizedRuleTypes, state.actions]);
  const defaultMenu = topNavCustomization === null || topNavCustomization === void 0 ? void 0 : topNavCustomization.defaultMenu;
  const appMenuPrimaryAndSecondaryItems = (0, _react.useMemo)(() => {
    var _defaultMenu$inspectI, _defaultMenu$alertsIt, _defaultMenu$newItem, _defaultMenu$openItem, _defaultMenu$shareIte;
    const items = [];
    if (!(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$inspectI = defaultMenu.inspectItem) !== null && _defaultMenu$inspectI !== void 0 && _defaultMenu$inspectI.disabled)) {
      const inspectAppMenuItem = (0, _app_menu_actions.getInspectAppMenuItem)({
        onOpenInspector
      });
      items.push(inspectAppMenuItem);
    }
    if (services.triggersActionsUi && !(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$alertsIt = defaultMenu.alertsItem) !== null && _defaultMenu$alertsIt !== void 0 && _defaultMenu$alertsIt.disabled) && discoverParams.authorizedRuleTypeIds.length) {
      const alertsAppMenuItem = (0, _app_menu_actions.getAlertsAppMenuItem)({
        discoverParams,
        services,
        stateContainer: state
      });
      items.push(alertsAppMenuItem);
    }
    if (!(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$newItem = defaultMenu.newItem) !== null && _defaultMenu$newItem !== void 0 && _defaultMenu$newItem.disabled)) {
      const newSearchMenuItem = (0, _app_menu_actions.getNewSearchAppMenuItem)({
        newSearchUrl,
        onNewSearch: () => {
          services.locator.navigate({});
        }
      });
      items.push(newSearchMenuItem);
    }
    if (!(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$openItem = defaultMenu.openItem) !== null && _defaultMenu$openItem !== void 0 && _defaultMenu$openItem.disabled)) {
      const openSearchMenuItem = (0, _app_menu_actions.getOpenSearchAppMenuItem)({
        onOpenSavedSearch: state.actions.onOpenSavedSearch
      });
      items.push(openSearchMenuItem);
    }
    if (!(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$shareIte = defaultMenu.shareItem) !== null && _defaultMenu$shareIte !== void 0 && _defaultMenu$shareIte.disabled)) {
      const shareAppMenuItem = (0, _app_menu_actions.getShareAppMenuItem)({
        discoverParams,
        services,
        stateContainer: state,
        hasIntegrations: hasShareIntegration
      });
      items.push(...shareAppMenuItem);
    }
    return items;
  }, [discoverParams, state, services, defaultMenu, onOpenInspector, newSearchUrl, hasShareIntegration]);
  const getAppMenuAccessor = (0, _context_awareness.useProfileAccessor)('getAppMenu');
  const appMenuRegistry = (0, _react.useMemo)(() => {
    const newAppMenuRegistry = new _discoverUtils.AppMenuRegistry(appMenuPrimaryAndSecondaryItems);
    const getAppMenu = getAppMenuAccessor(() => ({
      appMenuRegistry: () => newAppMenuRegistry
    }));
    return getAppMenu(discoverParams).appMenuRegistry(newAppMenuRegistry);
  }, [getAppMenuAccessor, discoverParams, appMenuPrimaryAndSecondaryItems]);
  return (0, _react.useMemo)(() => {
    var _defaultMenu$saveItem;
    const entries = appMenuRegistry.getSortedItems().map(appMenuItem => (0, _app_menu_actions.convertAppMenuItemToTopNavItem)({
      appMenuItem,
      services
    }));
    if (services.uiSettings.get(_esqlUtils.ENABLE_ESQL)) {
      /**
       * Switches from ES|QL to classic mode and vice versa
       */
      const esqLDataViewTransitionToggle = {
        id: 'esql',
        label: isEsqlMode ? _i18n.i18n.translate('discover.localMenu.switchToClassicTitle', {
          defaultMessage: 'Switch to classic'
        }) : _i18n.i18n.translate('discover.localMenu.tryESQLTitle', {
          defaultMessage: 'Try ES|QL'
        }),
        emphasize: true,
        fill: false,
        color: 'text',
        tooltip: isEsqlMode ? _i18n.i18n.translate('discover.localMenu.switchToClassicTooltipLabel', {
          defaultMessage: 'Switch to KQL or Lucene syntax.'
        }) : _i18n.i18n.translate('discover.localMenu.esqlTooltipLabel', {
          defaultMessage: `ES|QL is Elastic's powerful new piped query language.`
        }),
        run: () => {
          if (dataView) {
            if (isEsqlMode) {
              var _services$trackUiMetr;
              (_services$trackUiMetr = services.trackUiMetric) === null || _services$trackUiMetr === void 0 ? void 0 : _services$trackUiMetr.call(services, _analytics.METRIC_TYPE.CLICK, `esql:back_to_classic_clicked`);
              /**
               * Display the transition modal if:
               * - the user has not dismissed the modal
               * - the user has opened and applied changes to the saved search
               */
              if (shouldShowESQLToDataViewTransitionModal && !services.storage.get(_constants.ESQL_TRANSITION_MODAL_KEY)) {
                dispatch(_redux.internalStateActions.setIsESQLToDataViewTransitionModalVisible(true));
              } else {
                var _dataView$id;
                state.actions.transitionFromESQLToDataView((_dataView$id = dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : '');
              }
            } else {
              var _services$trackUiMetr2;
              state.actions.transitionFromDataViewToESQL(dataView);
              (_services$trackUiMetr2 = services.trackUiMetric) === null || _services$trackUiMetr2 === void 0 ? void 0 : _services$trackUiMetr2.call(services, _analytics.METRIC_TYPE.CLICK, `esql:try_btn_clicked`);
            }
          }
        },
        testId: isEsqlMode ? 'switch-to-dataviews' : 'select-text-based-language-btn'
      };
      entries.unshift(esqLDataViewTransitionToggle);
    }
    if (services.capabilities.discover.save && !(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$saveItem = defaultMenu.saveItem) !== null && _defaultMenu$saveItem !== void 0 && _defaultMenu$saveItem.disabled)) {
      const saveSearch = {
        id: 'save',
        label: _i18n.i18n.translate('discover.localMenu.saveTitle', {
          defaultMessage: 'Save'
        }),
        description: _i18n.i18n.translate('discover.localMenu.saveSearchDescription', {
          defaultMessage: 'Save session'
        }),
        testId: 'discoverSaveButton',
        iconType: 'save',
        emphasize: true,
        run: anchorElement => {
          (0, _on_save_search.onSaveSearch)({
            savedSearch: state.savedSearchState.getState(),
            services,
            state,
            onClose: () => {
              anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.focus();
            }
          });
        }
      };
      entries.push(saveSearch);
    }
    return entries;
  }, [appMenuRegistry, services, defaultMenu === null || defaultMenu === void 0 ? void 0 : (_defaultMenu$saveItem2 = defaultMenu.saveItem) === null || _defaultMenu$saveItem2 === void 0 ? void 0 : _defaultMenu$saveItem2.disabled, isEsqlMode, dataView, shouldShowESQLToDataViewTransitionModal, dispatch, state]);
};
exports.useTopNavLinks = useTopNavLinks;