"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoResultsSuggestionWhenFilters = NoResultsSuggestionWhenFilters;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function NoResultsSuggestionWhenFilters({
  onDisableFilters
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "discoverNoResultsAdjustFilters"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.noResults.suggestion.removeOrDisableFiltersText",
    defaultMessage: "Remove or {disableFiltersLink}",
    values: {
      disableFiltersLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "discoverNoResultsDisableFilters",
        onClick: onDisableFilters
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.noResults.suggestion.disableFiltersLinkText",
        defaultMessage: "disable filters"
      }))
    }
  }));
}