"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextAppContent = ContextAppContent;
exports.clamp = clamp;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/data-plugin/public");
var _cellActions = require("@kbn/cell-actions");
var _searchResponseWarnings = require("@kbn/search-response-warnings");
var _discoverUtils = require("@kbn/discover-utils");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _unifiedFieldList = require("@kbn/unified-field-list");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _i18nReact = require("@kbn/i18n-react");
var _discover_grid = require("../../components/discover_grid");
var _constants = require("../../../common/constants");
var _context_query_state = require("./services/context_query_state");
var _action_bar = require("./components/action_bar/action_bar");
var _context = require("./services/context");
var _constants2 = require("./services/constants");
var _doc_table_context = require("../../components/doc_table/doc_table_context");
var _use_discover_services = require("../../hooks/use_discover_services");
var _discover_grid_flyout = require("../../components/discover_grid_flyout");
var _on_resize_grid_column = require("../../utils/on_resize_grid_column");
var _context_awareness = require("../../context_awareness");
var _data_sources = require("../../../common/data_sources");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const controlColumnIds = ['openDetails'];
function clamp(value) {
  return Math.max(Math.min(_constants2.MAX_CONTEXT_SIZE, value), _constants2.MIN_CONTEXT_SIZE);
}
const DiscoverGridMemoized = /*#__PURE__*/_react.default.memo(_discover_grid.DiscoverGrid);
const DocTableContextMemoized = /*#__PURE__*/_react.default.memo(_doc_table_context.DocTableContext);
const ActionBarMemoized = /*#__PURE__*/_react.default.memo(_action_bar.ActionBar);
function ContextAppContent({
  columns,
  grid,
  onAddColumn,
  onRemoveColumn,
  onSetColumns,
  dataView,
  predecessorCount,
  successorCount,
  rows,
  predecessors,
  successors,
  anchorStatus,
  predecessorsStatus,
  successorsStatus,
  interceptedWarnings,
  useNewFieldsApi,
  isLegacy,
  setAppState,
  addFilter
}) {
  const {
    uiSettings: config,
    uiActions
  } = (0, _use_discover_services.useDiscoverServices)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const [expandedDoc, setExpandedDoc] = (0, _react.useState)();
  const [initialTabId, setInitialTabId] = (0, _react.useState)(undefined);
  const docViewerRef = (0, _react.useRef)(null);
  const setExpandedDocWithInitialTab = (0, _react.useCallback)((doc, options) => {
    setExpandedDoc(doc);
    setInitialTabId(options === null || options === void 0 ? void 0 : options.initialTabId);
    if (options !== null && options !== void 0 && options.initialTabId) {
      var _docViewerRef$current;
      (_docViewerRef$current = docViewerRef.current) === null || _docViewerRef$current === void 0 ? void 0 : _docViewerRef$current.setSelectedTabId(options.initialTabId);
    }
  }, []);
  const isAnchorLoading = anchorStatus === _context_query_state.LoadingStatus.LOADING || anchorStatus === _context_query_state.LoadingStatus.UNINITIALIZED;
  const arePredecessorsLoading = predecessorsStatus === _context_query_state.LoadingStatus.LOADING || predecessorsStatus === _context_query_state.LoadingStatus.UNINITIALIZED;
  const areSuccessorsLoading = successorsStatus === _context_query_state.LoadingStatus.LOADING || successorsStatus === _context_query_state.LoadingStatus.UNINITIALIZED;
  const showTimeCol = (0, _react.useMemo)(() => !config.get(_discoverUtils.DOC_HIDE_TIME_COLUMN_SETTING, false) && !!dataView.timeFieldName, [config, dataView]);
  const defaultStepSize = (0, _react.useMemo)(() => parseInt(config.get(_discoverUtils.CONTEXT_STEP_SETTING), 10), [config]);
  const loadingFeedback = () => {
    if (isLegacy && isAnchorLoading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        textAlign: "center",
        "data-test-subj": "contextApp_loadingIndicator"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.context.loadingDescription",
        defaultMessage: "Loading..."
      }));
    }
    return null;
  };
  const onChangeCount = (0, _react.useCallback)((type, count) => {
    const countKey = type === _context.SurrDocType.SUCCESSORS ? 'successorCount' : 'predecessorCount';
    setAppState({
      [countKey]: clamp(count)
    });
  }, [setAppState]);
  const sort = (0, _react.useMemo)(() => {
    return [[dataView.timeFieldName, _public.SortDirection.desc]];
  }, [dataView]);
  const renderDocumentView = (0, _react.useCallback)((hit, displayedRows, displayedColumns) => /*#__PURE__*/_react.default.createElement(_discover_grid_flyout.DiscoverGridFlyout, {
    dataView: dataView,
    hit: hit,
    hits: displayedRows
    // if default columns are used, dont make them part of the URL - the context state handling will take care to restore them
    ,
    columns: displayedColumns,
    onFilter: addFilter,
    onRemoveColumn: onRemoveColumn,
    onAddColumn: onAddColumn,
    onClose: () => setExpandedDoc(undefined),
    initialTabId: initialTabId,
    setExpandedDoc: setExpandedDocWithInitialTab,
    docViewerRef: docViewerRef
  }), [addFilter, dataView, onAddColumn, onRemoveColumn, setExpandedDocWithInitialTab, initialTabId]);
  const onResize = (0, _react.useCallback)(colSettings => {
    setAppState({
      grid: (0, _on_resize_grid_column.onResizeGridColumn)(colSettings, grid)
    });
  }, [grid, setAppState]);
  const configRowHeight = services.uiSettings.get(_discoverUtils.ROW_HEIGHT_OPTION);
  const getCellRenderersAccessor = (0, _context_awareness.useProfileAccessor)('getCellRenderers');
  const cellRenderers = (0, _react.useMemo)(() => {
    const getCellRenderers = getCellRenderersAccessor(() => ({}));
    return getCellRenderers({
      actions: {
        addFilter
      },
      dataView,
      density: (0, _unifiedDataTable.getDataGridDensity)(services.storage, 'discover'),
      rowHeight: (0, _unifiedDataTable.getRowHeight)({
        storage: services.storage,
        consumer: 'discover',
        configRowHeight
      })
    });
  }, [addFilter, configRowHeight, dataView, getCellRenderersAccessor, services.storage]);
  const dataSource = (0, _react.useMemo)(() => (0, _data_sources.createDataSource)({
    dataView,
    query: undefined
  }), [dataView]);
  const {
    filters
  } = (0, _unifiedFieldList.useQuerySubscriber)({
    data: services.data
  });
  const timeRange = (0, _useObservable.default)(services.timefilter.getTimeUpdate$().pipe((0, _rxjs.map)(() => services.timefilter.getTime())), services.timefilter.getTime());
  const cellActionsMetadata = (0, _context_awareness.useAdditionalCellActions)({
    dataSource,
    dataView,
    query: undefined,
    filters,
    timeRange
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(WrapperWithPadding, null, Boolean(interceptedWarnings.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_searchResponseWarnings.SearchResponseWarningsCallout, {
    warnings: interceptedWarnings
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(ActionBarMemoized, {
    type: _context.SurrDocType.PREDECESSORS,
    defaultStepSize: defaultStepSize,
    docCount: predecessorCount,
    docCountAvailable: predecessors.length,
    onChangeCount: onChangeCount,
    isLoading: arePredecessorsLoading,
    isDisabled: isAnchorLoading
  }), loadingFeedback()), isLegacy && rows && rows.length !== 0 && /*#__PURE__*/_react.default.createElement(DocTableContextMemoized, {
    columns: columns,
    dataView: dataView,
    rows: rows,
    isLoading: isAnchorLoading,
    onFilter: addFilter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    sort: sort,
    useNewFieldsApi: useNewFieldsApi,
    dataTestSubj: "contextDocTable"
  }), !isLegacy && /*#__PURE__*/_react.default.createElement("div", {
    className: "dscDocsGrid"
  }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: uiActions.getTriggerCompatibleActions
  }, /*#__PURE__*/_react.default.createElement(DiscoverGridMemoized, {
    ariaLabelledBy: "surDocumentsAriaLabel",
    cellActionsTriggerId: _context_awareness.DISCOVER_CELL_ACTIONS_TRIGGER.id,
    cellActionsMetadata: cellActionsMetadata,
    cellActionsHandling: "append",
    columns: columns,
    rows: rows,
    dataView: dataView,
    expandedDoc: expandedDoc,
    loadingState: isAnchorLoading ? _unifiedDataTable.DataLoadingState.loading : _unifiedDataTable.DataLoadingState.loaded,
    sampleSizeState: 0,
    sort: sort,
    isSortEnabled: false,
    showTimeCol: showTimeCol,
    useNewFieldsApi: useNewFieldsApi,
    isPaginationEnabled: false,
    rowsPerPageState: (0, _constants.getDefaultRowsPerPage)(services.uiSettings),
    controlColumnIds: controlColumnIds,
    setExpandedDoc: setExpandedDocWithInitialTab,
    onFilter: addFilter,
    onSetColumns: onSetColumns,
    configRowHeight: configRowHeight,
    showMultiFields: services.uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS),
    maxDocFieldsDisplayed: services.uiSettings.get(_discoverUtils.MAX_DOC_FIELDS_DISPLAYED),
    renderDocumentView: renderDocumentView,
    services: services,
    configHeaderRowHeight: 3,
    settings: grid,
    onResize: onResize,
    externalCustomRenderers: cellRenderers
  }))), /*#__PURE__*/_react.default.createElement(WrapperWithPadding, null, /*#__PURE__*/_react.default.createElement(ActionBarMemoized, {
    type: _context.SurrDocType.SUCCESSORS,
    defaultStepSize: defaultStepSize,
    docCount: successorCount,
    docCountAvailable: successors.length,
    onChangeCount: onChangeCount,
    isLoading: areSuccessorsLoading,
    isDisabled: isAnchorLoading
  })));
}
const WrapperWithPadding = ({
  children
}) => {
  const padding = (0, _eui.useEuiPaddingSize)('s');
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        padding: 0 ${padding};
      `
  }, children);
};