"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateComponentTemplate = updateComponentTemplate;
var _component_template_name = require("../../../../common/utils/component_template_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateComponentTemplate({
  datasetQualityESClient,
  indexTemplate,
  newFieldLimit
}) {
  const newSettings = {
    settings: {
      'index.mapping.total_fields.limit': newFieldLimit
    }
  };
  const customComponentTemplateName = `${(0, _component_template_name.getComponentTemplatePrefixFromIndexTemplate)(indexTemplate)}@custom`;
  try {
    const {
      acknowledged
    } = await datasetQualityESClient.updateComponentTemplate({
      name: customComponentTemplateName,
      template: newSettings
    });
    return {
      acknowledged,
      componentTemplateName: customComponentTemplateName
    };
  } catch (error) {
    return {
      acknowledged: undefined,
      // acknowledge is undefined when the request fails
      componentTemplateName: customComponentTemplateName,
      error: error.message
    };
  }
}