"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDegradedFieldValues = getDegradedFieldValues;
var _utils = require("../../../utils");
var _es_fields = require("../../../../common/es_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDegradedFieldValues({
  esClient,
  dataStream,
  degradedField
}) {
  const datasetQualityESClient = (0, _utils.createDatasetQualityESClient)(esClient);
  const response = await datasetQualityESClient.search({
    index: dataStream,
    size: 4,
    fields: [degradedField],
    query: {
      term: {
        [_es_fields._IGNORED]: degradedField
      }
    },
    sort: [{
      [_es_fields.TIMESTAMP]: {
        order: 'desc'
      }
    }]
  });
  const values = extractAndDeduplicateValues(response.hits.hits, degradedField);
  return {
    field: degradedField,
    values
  };
}
function extractAndDeduplicateValues(searchHits, key) {
  const values = [];
  searchHits.forEach(hit => {
    var _hit$ignored_field_va;
    const fieldValue = (_hit$ignored_field_va = hit.ignored_field_values) === null || _hit$ignored_field_va === void 0 ? void 0 : _hit$ignored_field_va[key];
    if (fieldValue) {
      if (Array.isArray(fieldValue)) {
        values.push(...fieldValue);
      } else {
        values.push(fieldValue);
      }
    }
  });

  // Flatten and deduplicate the array
  const deduplicatedValues = Array.from(new Set(values.flat()));
  return deduplicatedValues;
}