"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamSettings = getDataStreamSettings;
var _to_boolean = require("../../../utils/to_boolean");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FIELD_LIMIT = 1000;
const DEFAULT_NESTED_FIELD_LIMIT = 50;
async function getDataStreamSettings({
  datasetQualityESClient,
  dataStream,
  lastBackingIndex
}) {
  var _settings$lastBacking, _setting$index, _mappingsInsideSettin, _mappingsInsideSettin2, _mappingsInsideSettin3, _mappingsInsideSettin4, _mappingsInsideSettin5, _setting$index2;
  const settings = await datasetQualityESClient.settings({
    index: dataStream
  });
  const setting = (_settings$lastBacking = settings[lastBackingIndex]) === null || _settings$lastBacking === void 0 ? void 0 : _settings$lastBacking.settings;
  const mappingsInsideSettings = setting === null || setting === void 0 ? void 0 : (_setting$index = setting.index) === null || _setting$index === void 0 ? void 0 : _setting$index.mapping;
  return {
    nestedFieldLimit: mappingsInsideSettings !== null && mappingsInsideSettings !== void 0 && (_mappingsInsideSettin = mappingsInsideSettings.nested_fields) !== null && _mappingsInsideSettin !== void 0 && _mappingsInsideSettin.limit ? Number(mappingsInsideSettings === null || mappingsInsideSettings === void 0 ? void 0 : (_mappingsInsideSettin2 = mappingsInsideSettings.nested_fields) === null || _mappingsInsideSettin2 === void 0 ? void 0 : _mappingsInsideSettin2.limit) : DEFAULT_NESTED_FIELD_LIMIT,
    totalFieldLimit: mappingsInsideSettings !== null && mappingsInsideSettings !== void 0 && (_mappingsInsideSettin3 = mappingsInsideSettings.total_fields) !== null && _mappingsInsideSettin3 !== void 0 && _mappingsInsideSettin3.limit ? Number(mappingsInsideSettings === null || mappingsInsideSettings === void 0 ? void 0 : (_mappingsInsideSettin4 = mappingsInsideSettings.total_fields) === null || _mappingsInsideSettin4 === void 0 ? void 0 : _mappingsInsideSettin4.limit) : DEFAULT_FIELD_LIMIT,
    ignoreDynamicBeyondLimit: (0, _to_boolean.toBoolean)(mappingsInsideSettings === null || mappingsInsideSettings === void 0 ? void 0 : (_mappingsInsideSettin5 = mappingsInsideSettings.total_fields) === null || _mappingsInsideSettin5 === void 0 ? void 0 : _mappingsInsideSettin5.ignore_dynamic_beyond_limit),
    ignoreMalformed: (0, _to_boolean.toBoolean)(mappingsInsideSettings === null || mappingsInsideSettings === void 0 ? void 0 : mappingsInsideSettings.ignore_malformed),
    defaultPipeline: setting === null || setting === void 0 ? void 0 : (_setting$index2 = setting.index) === null || _setting$index2 === void 0 ? void 0 : _setting$index2.default_pipeline
  };
}