"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDegradedDocsPaginated = getDegradedDocsPaginated;
var _utils = require("../../../common/utils");
var _es_fields = require("../../../common/es_fields");
var _get_dataset_aggregated_paginated_results = require("./get_dataset_aggregated_paginated_results");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDegradedDocsPaginated(options) {
  const {
    esClient,
    types,
    datasetQuery,
    start,
    end
  } = options;
  const datasetNames = datasetQuery ? [datasetQuery] : types.map(type => (0, _utils.streamPartsToIndexPattern)({
    typePattern: type,
    datasetPattern: '*-*'
  }));
  return await (0, _get_dataset_aggregated_paginated_results.getAggregatedDatasetPaginatedResults)({
    esClient,
    start,
    end,
    index: datasetNames.join(','),
    query: {
      must: {
        exists: {
          field: _es_fields._IGNORED
        }
      }
    }
  });
}