"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedDocsErrors = getFailedDocsErrors;
var _constants = require("../../../../common/constants");
var _es_fields = require("../../../../common/es_fields");
var _utils = require("../../../utils");
var _queries = require("../../../utils/queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getFailedDocsErrors({
  esClient,
  start,
  end,
  dataStream
}) {
  const datasetQualityESClient = (0, _utils.createDatasetQualityESClient)(esClient);
  const bool = {
    filter: [...(0, _queries.rangeQuery)(start, end)]
  };
  const response = await datasetQualityESClient.search({
    index: `${dataStream}${_constants.FAILURE_STORE_SELECTOR}`,
    size: 10000,
    query: {
      bool
    },
    sort: [{
      [_es_fields.TIMESTAMP]: {
        order: 'desc'
      }
    }]
  });
  const errors = extractAndDeduplicateValues(response.hits.hits);
  return {
    errors
  };
}
function extractAndDeduplicateValues(searchHits) {
  const values = {};
  searchHits.forEach(hit => {
    var _hit$_source, _hit$_source$error, _hit$_source2, _hit$_source2$error;
    const fieldKey = (_hit$_source = hit._source) === null || _hit$_source === void 0 ? void 0 : (_hit$_source$error = _hit$_source.error) === null || _hit$_source$error === void 0 ? void 0 : _hit$_source$error.type;
    const fieldValue = (_hit$_source2 = hit._source) === null || _hit$_source2 === void 0 ? void 0 : (_hit$_source2$error = _hit$_source2.error) === null || _hit$_source2$error === void 0 ? void 0 : _hit$_source2$error.message;
    if (!values[fieldKey]) {
      // Here we will create a set if not already present
      values[fieldKey] = new Set();
    }
    // here set.add will take care of dedupe
    values[fieldKey].add(fieldValue);
  });
  return Object.entries(values).flatMap(([key, messages]) => Array.from(messages).map(message => ({
    type: key,
    message
  })));
}