"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callApi = callApi;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFetchOptions(fetchOptions) {
  const {
    body,
    ...rest
  } = fetchOptions;
  return {
    ...rest,
    ...(body !== undefined ? {
      body: JSON.stringify(body)
    } : {}),
    query: {
      ...fetchOptions.query
    }
  };
}
async function callApi({
  http
}, fetchOptions) {
  const {
    pathname,
    method = 'get',
    ...options
  } = getFetchOptions(fetchOptions);
  const lowercaseMethod = method.toLowerCase();
  const res = await http[lowercaseMethod](pathname, options);
  return res;
}