"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Integration = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Integration {
  constructor(integration) {
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "version", void 0);
    (0, _defineProperty2.default)(this, "datasets", void 0);
    (0, _defineProperty2.default)(this, "icons", void 0);
    this.name = integration.name;
    this.title = integration.title || integration.name;
    this.version = integration.version || '1.0.0';
    this.icons = integration.icons;
    this.datasets = integration.datasets || {};
  }
  static create(integration) {
    const integrationProps = {
      ...integration,
      title: integration.title || integration.name,
      version: integration.version || '1.0.0',
      datasets: integration.datasets || {}
    };
    return new Integration(integrationProps);
  }
}
exports.Integration = Integration;