"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FileDataVisualizerLite = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _fileUpload = require("@kbn/file-upload");
var _file_upload_lite_view = require("./file_upload_lite_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileDataVisualizerLite = ({
  coreStart,
  plugins,
  getAdditionalLinks,
  resultLinks,
  props,
  onClose
}) => {
  var _cloud$CloudContextPr;
  const services = {
    ...coreStart,
    ...plugins
  };
  const {
    data,
    fileUpload,
    cloud,
    notifications
  } = services;
  const {
    existingIndex,
    autoAddInference,
    autoCreateDataView,
    indexSettings,
    onUploadComplete
  } = props;
  const fileUploadManager = (0, _react.useMemo)(() => new _fileUpload.FileUploadManager(fileUpload, coreStart.http, data.dataViews, notifications, autoAddInference !== null && autoAddInference !== void 0 ? autoAddInference : null, autoCreateDataView, true, existingIndex !== null && existingIndex !== void 0 ? existingIndex : null, indexSettings), [autoAddInference, autoCreateDataView, coreStart.http, data.dataViews, existingIndex, fileUpload, indexSettings, notifications]);
  const fileUploadContextValue = (0, _fileUpload.useFileUpload)(fileUploadManager, data, coreStart.application, coreStart.http, notifications, onUploadComplete);
  const EmptyContext = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  const CloudContext = (_cloud$CloudContextPr = cloud === null || cloud === void 0 ? void 0 : cloud.CloudContextProvider) !== null && _cloud$CloudContextPr !== void 0 ? _cloud$CloudContextPr : EmptyContext;
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...services
    }
  }, /*#__PURE__*/_react.default.createElement(CloudContext, null, /*#__PURE__*/_react.default.createElement(_fileUpload.FileUploadContext.Provider, {
    value: fileUploadContextValue
  }, /*#__PURE__*/_react.default.createElement(_file_upload_lite_view.FileUploadLiteView, {
    getAdditionalLinks: getAdditionalLinks,
    resultLinks: resultLinks,
    props: props,
    onClose: onClose
  })))));
};

// exporting as default so it can be used with React.lazy
// eslint-disable-next-line import/no-default-export
exports.FileDataVisualizerLite = FileDataVisualizerLite;
var _default = exports.default = FileDataVisualizerLite;