"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _fileUpload = require("@kbn/file-upload");
var _analysis_summary = require("../application/file_data_visualizer/components/analysis_summary");
var _file_contents = require("../application/file_data_visualizer/components/file_contents");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var TAB = /*#__PURE__*/function (TAB) {
  TAB[TAB["SUMMARY"] = 0] = "SUMMARY";
  TAB[TAB["CONTENT"] = 1] = "CONTENT";
  return TAB;
}(TAB || {});
const FileStatus = ({
  fileStatus,
  uploadStatus,
  deleteFile,
  index,
  showFileContentPreview = false,
  showFileSummary = false
}) => {
  var _uploadStatus$fileCla;
  const fileClash = (_uploadStatus$fileCla = uploadStatus.fileClashes[index]) !== null && _uploadStatus$fileCla !== void 0 ? _uploadStatus$fileCla : {
    clash: false
  };
  const [expanded, setExpanded] = (0, _react.useState)(false);
  const [selectedTab, setSelectedTab] = (0, _react.useState)(showFileSummary ? TAB.SUMMARY : TAB.CONTENT);
  const importStarted = uploadStatus.overallImportStatus === _fileUpload.STATUS.STARTED || uploadStatus.overallImportStatus === _fileUpload.STATUS.COMPLETED;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s",
    color: fileClash.clash ? 'danger' : 'transparent'
  }, importStarted ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: Math.floor(fileStatus.importProgress),
    max: 100,
    size: "s",
    label: fileStatus.fileName,
    valueText: true,
    color: fileStatus.importProgress === 100 ? 'success' : 'primary'
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, showFileContentPreview || showFileSummary ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: expanded ? 'arrowDown' : 'arrowRight',
    "aria-label": "expand",
    onClick: () => setExpanded(!expanded)
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 8
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: {
      fontWeight: 'bold'
    }
  }, fileStatus.fileName), "\xA0", /*#__PURE__*/_react.default.createElement("span", null, fileStatus.fileSizeInfo.fileSizeFormatted))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: deleteFile,
    iconType: "trash",
    size: "xs",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.file.fileStatus.deleteFile', {
      defaultMessage: 'Remove file'
    })
  }))))))), fileClash.clash ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fileClash.clashType === _fileUpload.CLASH_TYPE.FORMAT ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.fileFormatClash",
    defaultMessage: "File format different from other files"
  }))) : null, fileClash.clashType === _fileUpload.CLASH_TYPE.MAPPING ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.mappingClash",
    defaultMessage: "Mappings incompatible with other files"
  }))) : null, fileClash.clashType === _fileUpload.CLASH_TYPE.UNSUPPORTED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.fileFormatNotSupported",
    defaultMessage: "File format not supported"
  }))) : null) : null, expanded ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s"
  }, showFileContentPreview && showFileSummary ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.SUMMARY,
    onClick: () => setSelectedTab(TAB.SUMMARY),
    "data-test-subj": "mlNodesOverviewPanelDetailsTab"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.summaryTabTitle",
    defaultMessage: "Summary"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.CONTENT,
    onClick: () => setSelectedTab(TAB.CONTENT),
    "data-test-subj": "mlNodesOverviewPanelMemoryTab"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.contentTabTitle",
    defaultMessage: "Content"
  }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), selectedTab === TAB.SUMMARY ? /*#__PURE__*/_react.default.createElement(_analysis_summary.AnalysisSummary, {
    results: fileStatus.results,
    showTitle: false
  }) : null, selectedTab === TAB.CONTENT ? /*#__PURE__*/_react.default.createElement(_file_contents.FileContents, {
    fileContents: fileStatus.fileContents,
    results: fileStatus.results,
    showTitle: false,
    disableHighlighting: true
  }) : null) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.FileStatus = FileStatus;