"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeFieldStatsControls = void 0;
var _esqlUtils = require("@kbn/esql-utils");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _types = require("../grid_embeddable/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeFieldStatsControls = (rawState, uiSettings) => {
  const isEsqlEnabled = uiSettings.get(_esqlUtils.ENABLE_ESQL);
  const defaultType = isEsqlEnabled ? _types.FieldStatsInitializerViewType.ESQL : _types.FieldStatsInitializerViewType.DATA_VIEW;
  const defaults = {
    showDistributions: false,
    viewType: defaultType,
    dataViewId: undefined,
    query: undefined
  };
  const fieldStatsStateManager = (0, _presentationPublishing.initializeStateManager)(rawState, defaults);
  const resetData$ = new _rxjs.BehaviorSubject(Date.now());
  const dataLoading$ = new _rxjs.BehaviorSubject(true);
  const blockingError$ = new _rxjs.BehaviorSubject(undefined);
  const updateUserInput = (update, shouldResetData = false) => {
    if (shouldResetData) {
      resetData$.next(Date.now());
    }
    fieldStatsStateManager.api.setViewType(update.viewType);
    fieldStatsStateManager.api.setDataViewId(update.dataViewId);
    fieldStatsStateManager.api.setQuery(update.query);
  };
  const fieldStatsControlsComparators = {
    viewType: 'referenceEquality',
    dataViewId: 'referenceEquality',
    query: 'deepEquality',
    showDistributions: 'referenceEquality'
  };
  const onRenderComplete = () => dataLoading$.next(false);
  const onLoading = v => dataLoading$.next(v);
  const onError = error => blockingError$.next(error);
  return {
    fieldStatsControlsApi: {
      updateUserInput,
      query$: fieldStatsStateManager.api.query$,
      viewType$: fieldStatsStateManager.api.viewType$,
      dataViewId$: fieldStatsStateManager.api.dataViewId$,
      showDistributions$: fieldStatsStateManager.api.showDistributions$
    },
    dataLoadingApi: {
      dataLoading$,
      blockingError$,
      onRenderComplete,
      onLoading,
      onError
    },
    fieldStatsStateManager,
    // Reset data is internal state management, so no need to expose this in api
    resetData$,
    serializeFieldStatsChartState: () => fieldStatsStateManager.getLatestState(),
    fieldStatsControlsComparators,
    onFieldStatsTableDestroy: () => {
      fieldStatsStateManager.api.viewType$.complete();
      fieldStatsStateManager.api.dataViewId$.complete();
      fieldStatsStateManager.api.query$.complete();
      resetData$.complete();
    }
  };
};
exports.initializeFieldStatsControls = initializeFieldStatsControls;