"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.displayError = displayError;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function displayError(toastNotifications, index, err) {
  if (err.statusCode === 500) {
    var _err$error;
    toastNotifications.addError(err, {
      title: _i18n.i18n.translate('xpack.dataVisualizer.index.dataLoader.internalServerErrorMessage', {
        defaultMessage: 'Error loading data in index {index}. {message}. ' + 'The request may have timed out. Try using a smaller sample size or narrowing the time range.',
        values: {
          index,
          message: (_err$error = err.error) !== null && _err$error !== void 0 ? _err$error : err.message
        }
      })
    });
  } else {
    var _err$error2;
    toastNotifications.addError(err, {
      title: _i18n.i18n.translate('xpack.dataVisualizer.index.errorLoadingDataMessage', {
        defaultMessage: 'Error loading data in index {index}. {message}.',
        values: {
          index,
          message: (_err$error2 = err.error) !== null && _err$error2 !== void 0 ? _err$error2 : err.message
        }
      })
    });
  }
}