"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.numberAsOrdinal = numberAsOrdinal;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

/**
 * Formats the supplied number as ordinal e.g. 15 as 15th.
 * Formatting first converts the supplied number to an integer by flooring.
 * @param {number} value to format as an ordinal
 * @return {string} number formatted as an ordinal e.g. 15th
 */
function numberAsOrdinal(num) {
  const int = Math.floor(num);
  return `${(0, _numeral.default)(int).format('0o')}`;
}