"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.featureTitle = exports.featureId = exports.applicationPath = exports.SUPPORTED_FIELD_TYPES_LIST = exports.SUPPORTED_FIELD_TYPES = exports.OMIT_FIELDS = exports.NON_AGGREGATABLE_FIELD_TYPES = exports.FILE_DATA_VIS_TAB_ID = exports.APP_ID = void 0;
var _i18n = require("@kbn/i18n");
var _fieldTypes = require("@kbn/field-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APP_ID = exports.APP_ID = 'data_visualizer';
const SUPPORTED_FIELD_TYPES = exports.SUPPORTED_FIELD_TYPES = {
  BOOLEAN: 'boolean',
  CONFLICT: 'conflict',
  DATE: 'date',
  DATE_RANGE: 'date_range',
  GEO_POINT: 'geo_point',
  GEO_SHAPE: 'geo_shape',
  HISTOGRAM: 'histogram',
  IP: 'ip',
  IP_RANGE: 'ip_range',
  KEYWORD: 'keyword',
  MURMUR3: 'murmur3',
  NUMBER: 'number',
  NESTED: 'nested',
  STRING: 'string',
  TEXT: 'text',
  SEMANTIC_TEXT: 'semantic_text',
  DENSE_VECTOR: 'dense_vector',
  SPARSE_VECTOR: 'sparse_vector',
  VERSION: 'version',
  UNKNOWN: 'unknown'
};
const OMIT_FIELDS = exports.OMIT_FIELDS = ['_source', '_type', '_index', '_id', '_version', '_score', '_tier', '_ignored'];
const NON_AGGREGATABLE_FIELD_TYPES = exports.NON_AGGREGATABLE_FIELD_TYPES = new Set([_fieldTypes.KBN_FIELD_TYPES.GEO_SHAPE, _fieldTypes.KBN_FIELD_TYPES.HISTOGRAM]);
const FILE_DATA_VIS_TAB_ID = exports.FILE_DATA_VIS_TAB_ID = 'fileDataViz';
const applicationPath = exports.applicationPath = `/app/home#/tutorial_directory/${FILE_DATA_VIS_TAB_ID}`;
const featureTitle = exports.featureTitle = _i18n.i18n.translate('xpack.dataVisualizer.title', {
  defaultMessage: 'Upload a file'
});
const featureId = exports.featureId = `file_data_visualizer`;
const SUPPORTED_FIELD_TYPES_LIST = exports.SUPPORTED_FIELD_TYPES_LIST = Object.values(SUPPORTED_FIELD_TYPES);