"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewsApiClient = void 0;
exports.getFieldsForWildcardRequestBody = getFieldsForWildcardRequestBody;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lib = require("../../common/lib");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const API_BASE_URL = `/api/index_patterns/`;
const version = '1';
async function sha1(str) {
  if (crypto.subtle) {
    const enc = new TextEncoder();
    const hash = await crypto.subtle.digest('SHA-256', enc.encode(str));
    return Array.from(new Uint8Array(hash)).map(v => v.toString(16).padStart(2, '0')).join('');
  } else {
    const {
      sha256
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./sha256')));
    return sha256(str);
  }
}

/**
 * Helper function to get the request body for the getFieldsForWildcard request
 * @param options options for fields request
 * @returns string | undefined
 */
function getFieldsForWildcardRequestBody(options) {
  const {
    indexFilter,
    runtimeMappings
  } = options;
  if (!indexFilter && !runtimeMappings) {
    return;
  }
  return JSON.stringify({
    ...(indexFilter && {
      index_filter: indexFilter
    }),
    ...(runtimeMappings && {
      runtime_mappings: runtimeMappings
    })
  });
}

/**
 * Data Views API Client - client implementation
 */
class DataViewsApiClient {
  /**
   * constructor
   * @param http http dependency
   */
  constructor(http, getCurrentUserId) {
    (0, _defineProperty2.default)(this, "http", void 0);
    (0, _defineProperty2.default)(this, "getCurrentUserId", void 0);
    this.http = http;
    this.getCurrentUserId = getCurrentUserId;
  }
  async _request(url, query, body, forceRefresh, abortSignal) {
    const asResponse = true;
    const cacheOptions = forceRefresh ? {
      cache: 'no-cache'
    } : {};
    const userId = await this.getCurrentUserId();
    const userHash = userId ? await sha1(userId) : '';
    const headers = userHash ? {
      'user-hash': userHash
    } : undefined;
    const request = body ? this.http.post(url, {
      query,
      body,
      version,
      asResponse,
      signal: abortSignal
    }) : this.http.fetch(url, {
      query,
      version,
      ...cacheOptions,
      asResponse,
      headers,
      signal: abortSignal
    });
    return request.catch(resp => {
      // Custom errors with a body
      if (resp !== null && resp !== void 0 && resp.body) {
        var _resp$body$attributes;
        if (resp.body.statusCode === 404 && ((_resp$body$attributes = resp.body.attributes) === null || _resp$body$attributes === void 0 ? void 0 : _resp$body$attributes.code) === 'no_matching_indices') {
          throw new _lib.DataViewMissingIndices(resp.body.message);
        }
        throw new Error(resp.body.message || resp.body.error || `${resp.body.statusCode} Response`);
      }

      // Regular errors including AbortError
      if (typeof (resp === null || resp === void 0 ? void 0 : resp.name) === 'string' && typeof (resp === null || resp === void 0 ? void 0 : resp.message) === 'string') {
        throw resp;
      }

      // Other unknown errors
      throw new Error('Unknown error');
    });
  }
  _getUrl(path) {
    return API_BASE_URL + path.filter(Boolean).map(encodeURIComponent).join('/');
  }

  /**
   * Get field list for a given index pattern
   * @param options options for fields request
   */
  getFieldsForWildcard(options) {
    const {
      pattern,
      metaFields,
      type,
      rollupIndex,
      allowNoIndex,
      indexFilter,
      includeUnmapped,
      fields,
      forceRefresh,
      allowHidden,
      fieldTypes,
      includeEmptyFields,
      abortSignal
    } = options;
    const path = indexFilter ? _constants.FIELDS_FOR_WILDCARD_PATH : _constants.FIELDS_PATH;
    const versionQueryParam = indexFilter ? {} : {
      apiVersion: version
    };
    return this._request(path, {
      pattern,
      meta_fields: metaFields,
      type,
      rollup_index: rollupIndex,
      allow_no_index: allowNoIndex,
      include_unmapped: includeUnmapped,
      fields,
      field_types: fieldTypes,
      // default to undefined to keep value out of URL params and improve caching
      allow_hidden: allowHidden || undefined,
      include_empty_fields: includeEmptyFields,
      ...versionQueryParam
    }, getFieldsForWildcardRequestBody(options), forceRefresh, abortSignal).then(response => {
      var _response$body, _response$body2, _response$response, _response$response$he;
      return {
        indices: (response === null || response === void 0 ? void 0 : (_response$body = response.body) === null || _response$body === void 0 ? void 0 : _response$body.indices) || [],
        fields: (response === null || response === void 0 ? void 0 : (_response$body2 = response.body) === null || _response$body2 === void 0 ? void 0 : _response$body2.fields) || [],
        etag: (response === null || response === void 0 ? void 0 : (_response$response = response.response) === null || _response$response === void 0 ? void 0 : (_response$response$he = _response$response.headers) === null || _response$response$he === void 0 ? void 0 : _response$response$he.get('etag')) || ''
      };
    });
  }

  /**
   * Does a user created data view exist?
   */
  async hasUserDataView() {
    var _response$body$result, _response$body3;
    const response = await this._request(this._getUrl(['has_user_index_pattern']));
    return (_response$body$result = response === null || response === void 0 ? void 0 : (_response$body3 = response.body) === null || _response$body3 === void 0 ? void 0 : _response$body3.result) !== null && _response$body$result !== void 0 ? _response$body$result : false;
  }
}
exports.DataViewsApiClient = DataViewsApiClient;