"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRegExpPatternFrom = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createRegExpPatternFrom = (basePatterns, selector) => {
  const normalizedBasePatterns = normalizeBasePatterns(basePatterns);
  const indexNames = `(?:${normalizedBasePatterns.join('|')})`;
  const selectorsSuffix = `(?:::(?:${(0, _lodash.escapeRegExp)(selector)}))${isDefaultSelector(selector) ? '?' : ''}`;
  return new RegExp(`^(?:${optionalRemoteCluster}${optionalIndexNamePrefix}${indexNames}${optionalIndexNameSuffix}${selectorsSuffix},?)+$`, 'i');
};
exports.createRegExpPatternFrom = createRegExpPatternFrom;
const normalizeBasePatterns = basePatterns => (Array.isArray(basePatterns) ? basePatterns : [basePatterns]).map(_lodash.escapeRegExp);
const isDefaultSelector = selector => selector === 'data';
const nameCharacters = '[^:,\\s]+';
const segmentBoundary = '(?:\\b|_)';
const optionalRemoteCluster = `(?:${nameCharacters}:)?`;
const optionalIndexNamePrefix = `(?:${nameCharacters}${segmentBoundary})?`;
const optionalIndexNameSuffix = `(?:${segmentBoundary}${nameCharacters})?`;