"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelationshipsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _plugin = require("../../../plugin");
var _i18n = require("./i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const canGoInApp = (savedObject, capabilities) => {
  const {
    inAppUrl
  } = savedObject.meta;
  if (!inAppUrl) return false;
  if (!inAppUrl.uiCapabilitiesPath) return true;
  return Boolean((0, _lodash.get)(capabilities, inAppUrl.uiCapabilitiesPath));
};
const RelationshipsTable = ({
  basePath,
  capabilities,
  id,
  navigateToUrl,
  getDefaultTitle,
  getSavedObjectLabel,
  relationships,
  allowedTypes
}) => {
  const columns = [{
    field: 'type',
    name: _i18n.typeFieldName,
    width: '50px',
    align: 'center',
    description: _i18n.typeFieldDescription,
    sortable: false,
    render: (type, object) => {
      const typeLabel = getSavedObjectLabel(type, allowedTypes);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: typeLabel
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        "aria-label": typeLabel,
        type: object.meta.icon || 'apps',
        size: "s",
        "data-test-subj": "relationshipsObjectType"
      }));
    }
  }, {
    field: 'title',
    name: _i18n.titleFieldName,
    description: _i18n.titleFieldDescription,
    dataType: 'string',
    sortable: false,
    render: (title, object) => {
      var _object$meta$inAppUrl;
      const path = ((_object$meta$inAppUrl = object.meta.inAppUrl) === null || _object$meta$inAppUrl === void 0 ? void 0 : _object$meta$inAppUrl.path) || '';
      const showUrl = canGoInApp(object, capabilities);
      const titleDisplayed = title || getDefaultTitle(object);
      return showUrl ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: basePath.prepend(path),
        "data-test-subj": "relationshipsTitle"
      }, titleDisplayed) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        "data-test-subj": "relationshipsTitle"
      }, titleDisplayed);
    }
  }];
  const filterTypesMap = new Map(relationships.map(relationship => [relationship.type, {
    value: relationship.type,
    name: relationship.type,
    view: relationship.type
  }]));
  const search = {
    // query,
    // onChange: handleOnChange,
    box: {
      incremental: true,
      schema: true
    },
    filters: [{
      type: 'field_value_selection',
      field: 'type',
      name: _i18n.filterTitle,
      multiSelect: 'or',
      options: [...filterTypesMap.values()]
    }]
  };
  const {
    pageSize,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'dataViewMgmtRelationships',
    initialPageSize: 10
  });
  return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    currentAppId: _plugin.IPM_APP_ID,
    navigateToUrl: navigateToUrl
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: relationships,
    columns: columns,
    pagination: {
      pageSize
    },
    onTableChange: onTableChange,
    search: search,
    rowProps: () => ({
      'data-test-subj': `relationshipsTableRow`
    })
  }));
};
exports.RelationshipsTable = RelationshipsTable;