"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternFieldEditorPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _open_editor = require("./open_editor");
var _format_editor_service = require("./service/format_editor_service");
var _delete_field_provider = require("./components/delete_field_provider");
var _open_delete_modal = require("./open_delete_modal");
var _api = require("./lib/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class IndexPatternFieldEditorPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "formatEditorService", new _format_editor_service.FormatEditorService());
  }
  setup(core, plugins) {
    const {
      fieldFormatEditors
    } = this.formatEditorService.setup();
    return {
      fieldFormatEditors
    };
  }
  start(core, plugins) {
    const {
      fieldFormatEditors
    } = this.formatEditorService.start();
    const {
      http
    } = core;
    const {
      data,
      usageCollection,
      dataViews,
      fieldFormats
    } = plugins;
    const openDeleteModal = (0, _open_delete_modal.getFieldDeleteModalOpener)({
      core,
      dataViews,
      usageCollection
    });
    return {
      fieldFormatEditors,
      openEditor: (0, _open_editor.getFieldEditorOpener)({
        core,
        dataViews,
        apiService: (0, _api.initApi)(http),
        fieldFormats,
        fieldFormatEditors,
        search: data.search,
        usageCollection
      }),
      openDeleteModal,
      userPermissions: {
        editIndexPattern: () => dataViews.getCanSaveSync()
      },
      DeleteRuntimeFieldProvider: (0, _delete_field_provider.getDeleteFieldProvider)(openDeleteModal)
    };
  }
}
exports.IndexPatternFieldEditorPlugin = IndexPatternFieldEditorPlugin;