"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExtendActionDescriptor = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _extend_session = _interopRequireDefault(require("../../icons/extend_session.svg"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ExtendConfirm = ({
  ...props
}) => {
  const {
    searchSession,
    api,
    onActionDismiss
  } = props;
  const {
    id,
    name,
    expires
  } = searchSession;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const extendByDuration = _moment.default.duration(api.getExtendByDuration());
  const newExpiration = (0, _moment.default)(expires).add(extendByDuration);
  const title = _i18n.i18n.translate('data.mgmt.searchSessions.extendModal.title', {
    defaultMessage: 'Extend search session expiration'
  });
  const confirm = _i18n.i18n.translate('data.mgmt.searchSessions.extendModal.extendButton', {
    defaultMessage: 'Extend expiration'
  });
  const extend = _i18n.i18n.translate('data.mgmt.searchSessions.extendModal.dontExtendButton', {
    defaultMessage: 'Cancel'
  });
  const message = _i18n.i18n.translate('data.mgmt.searchSessions.extendModal.extendMessage', {
    defaultMessage: "The search session ''{name}'' expiration would be extended until {newExpires}.",
    values: {
      name,
      newExpires: newExpiration.toLocaleString()
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: title,
    onCancel: onActionDismiss,
    onConfirm: async () => {
      setIsLoading(true);
      await api.sendExtend(id, `${newExpiration.toISOString()}`);
      setIsLoading(false);
      onActionDismiss();
    },
    confirmButtonText: confirm,
    confirmButtonDisabled: isLoading,
    cancelButtonText: extend,
    defaultFocusedButton: "confirm",
    buttonColor: "primary"
  }, message);
};
const createExtendActionDescriptor = (api, uiSession, core) => ({
  iconType: _extend_session.default,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.mgmt.searchSessions.actionExtend",
    defaultMessage: "Extend"
  }),
  onClick: async () => {
    const ref = core.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(ExtendConfirm, {
      onActionDismiss: () => ref === null || ref === void 0 ? void 0 : ref.close(),
      searchSession: uiSession,
      api: api
    }), core));
    await ref.onClose;
  }
});
exports.createExtendActionDescriptor = createExtendActionDescriptor;