"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SearchSessionIndicator = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _custom_icons = require("./custom_icons");
require("./search_session_indicator.scss");
var _components = require("./components");
var _search_session_state = require("../../search_session_state");
var _search_sessions_deprecation_message = require("../../search_sessions_deprecation_message");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CancelButton = ({
  onCancel = () => {},
  buttonProps = {}
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
  onClick: onCancel,
  "data-test-subj": 'searchSessionIndicatorCancelBtn',
  color: "danger"
}, buttonProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "data.searchSessionIndicator.cancelButtonText",
  defaultMessage: "Stop session"
}));
const ContinueInBackgroundButton = ({
  onContinueInBackground = () => {},
  buttonProps = {},
  saveDisabled = false,
  saveDisabledReasonText
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: saveDisabledReasonText
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
  onClick: onContinueInBackground,
  "data-test-subj": 'searchSessionIndicatorSaveBtn',
  isDisabled: saveDisabled
}, buttonProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "data.searchSessionIndicator.continueInBackgroundButtonText",
  defaultMessage: "Save session"
})));
const ViewAllSearchSessionsButton = ({
  viewSearchSessionsLink = 'management/kibana/search_sessions',
  onViewSearchSessions = () => {},
  buttonProps = {},
  managementDisabled,
  managementDisabledReasonText
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: managementDisabledReasonText
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
  href: viewSearchSessionsLink,
  onClick: onViewSearchSessions,
  "data-test-subj": 'searchSessionIndicatorViewSearchSessionsLink',
  isDisabled: managementDisabled
}, buttonProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "data.searchSessionIndicator.viewSearchSessionsLinkText",
  defaultMessage: "Manage sessions"
})));
const SaveButton = ({
  onSaveResults = () => {},
  buttonProps = {},
  saveDisabled = false,
  saveDisabledReasonText
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: saveDisabledReasonText
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
  onClick: onSaveResults,
  "data-test-subj": 'searchSessionIndicatorSaveBtn',
  isDisabled: saveDisabled
}, buttonProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "data.searchSessionIndicator.saveButtonText",
  defaultMessage: "Save session"
})));
const searchSessionIndicatorViewStateToProps = {
  [_search_session_state.SearchSessionState.None]: null,
  [_search_session_state.SearchSessionState.Loading]: {
    button: {
      color: 'text',
      iconType: _custom_icons.PartialClock,
      'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.loadingResultsIconAriaLabel', {
        defaultMessage: 'Search session loading'
      }),
      tooltipText: _i18n.i18n.translate('data.searchSessionIndicator.loadingResultsIconTooltipText', {
        defaultMessage: 'Search session loading'
      })
    },
    popover: {
      title: _i18n.i18n.translate('data.searchSessionIndicator.loadingResultsTitle', {
        defaultMessage: 'Your search is taking a while...'
      }),
      description: _i18n.i18n.translate('data.searchSessionIndicator.loadingResultsDescription', {
        defaultMessage: 'Save your session, continue your work, and return to completed results'
      }),
      whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.loadingResultsWhenText', {
        defaultMessage: 'Started {when}',
        values: {
          when: props.startedTime ? (0, _moment.default)(props.startedTime).format(`L @ LTS`) : ''
        }
      }),
      primaryAction: CancelButton,
      secondaryAction: ContinueInBackgroundButton
    }
  },
  [_search_session_state.SearchSessionState.Completed]: {
    button: {
      color: 'text',
      iconType: 'check',
      'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.resultsLoadedIconAriaLabel', {
        defaultMessage: 'Search session complete'
      }),
      tooltipText: _i18n.i18n.translate('data.searchSessionIndicator.resultsLoadedIconTooltipText', {
        defaultMessage: 'Search session complete'
      })
    },
    popover: {
      title: _i18n.i18n.translate('data.searchSessionIndicator.resultsLoadedText', {
        defaultMessage: 'Search session complete'
      }),
      description: _i18n.i18n.translate('data.searchSessionIndicator.resultsLoadedDescriptionText', {
        defaultMessage: 'Save your session and return to it later'
      }),
      whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.resultsLoadedWhenText', {
        defaultMessage: 'Completed {when}',
        values: {
          when: props.completedTime ? (0, _moment.default)(props.completedTime).format(`L @ LTS`) : ''
        }
      }),
      primaryAction: SaveButton,
      secondaryAction: ViewAllSearchSessionsButton
    }
  },
  [_search_session_state.SearchSessionState.BackgroundLoading]: {
    button: {
      iconType: _eui.EuiLoadingSpinner,
      'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.loadingInTheBackgroundIconAriaLabel', {
        defaultMessage: 'Saved session in progress'
      }),
      tooltipText: _i18n.i18n.translate('data.searchSessionIndicator.loadingInTheBackgroundIconTooltipText', {
        defaultMessage: 'Saved session in progress'
      })
    },
    popover: {
      title: _i18n.i18n.translate('data.searchSessionIndicator.loadingInTheBackgroundTitleText', {
        defaultMessage: 'Saved session in progress'
      }),
      description: _i18n.i18n.translate('data.searchSessionIndicator.loadingInTheBackgroundDescriptionText', {
        defaultMessage: 'You can return to completed results from Management'
      }),
      whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.loadingInTheBackgroundWhenText', {
        defaultMessage: 'Started {when}',
        values: {
          when: props.startedTime ? (0, _moment.default)(props.startedTime).format(`L @ LTS`) : ''
        }
      }),
      primaryAction: CancelButton,
      secondaryAction: ViewAllSearchSessionsButton
    }
  },
  [_search_session_state.SearchSessionState.BackgroundCompleted]: {
    button: {
      color: 'success',
      iconType: 'checkInCircleFilled',
      'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.resultLoadedInTheBackgroundIconAriaLabel', {
        defaultMessage: 'Saved session complete'
      }),
      tooltipText: _i18n.i18n.translate('data.searchSessionIndicator.resultLoadedInTheBackgroundIconTooltipText', {
        defaultMessage: 'Saved session complete'
      })
    },
    popover: {
      title: _i18n.i18n.translate('data.searchSessionIndicator.resultLoadedInTheBackgroundTitleText', {
        defaultMessage: 'Search session saved'
      }),
      description: _i18n.i18n.translate('data.searchSessionIndicator.resultLoadedInTheBackgroundDescriptionText', {
        defaultMessage: 'You can return to these results from Management'
      }),
      whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.resultLoadedInTheBackgroundWhenText', {
        defaultMessage: 'Completed {when}',
        values: {
          when: props.completedTime ? (0, _moment.default)(props.completedTime).format(`L @ LTS`) : ''
        }
      }),
      secondaryAction: ViewAllSearchSessionsButton
    }
  },
  [_search_session_state.SearchSessionState.Restored]: {
    button: {
      color: 'success',
      iconType: _custom_icons.CheckInEmptyCircle,
      'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.restoredResultsIconAriaLabel', {
        defaultMessage: 'Saved session restored'
      }),
      tooltipText: _i18n.i18n.translate('data.searchSessionIndicator.restoredResultsTooltipText', {
        defaultMessage: 'Search session restored'
      })
    },
    popover: {
      title: _i18n.i18n.translate('data.searchSessionIndicator.restoredTitleText', {
        defaultMessage: 'Search session restored'
      }),
      description: _i18n.i18n.translate('data.searchSessionIndicator.restoredDescriptionText', {
        defaultMessage: 'You are viewing cached data from a specific time range. Changing the time range or filters will re-run the session'
      }),
      whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.restoredWhenText', {
        defaultMessage: 'Completed {when}',
        values: {
          when: props.completedTime ? (0, _moment.default)(props.completedTime).format(`L @ LTS`) : ''
        }
      }),
      secondaryAction: ViewAllSearchSessionsButton
    }
  },
  [_search_session_state.SearchSessionState.Canceled]: {
    button: {
      color: 'danger',
      iconType: 'error',
      'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.canceledIconAriaLabel', {
        defaultMessage: 'Search session stopped'
      }),
      tooltipText: _i18n.i18n.translate('data.searchSessionIndicator.canceledTooltipText', {
        defaultMessage: 'Search session stopped'
      })
    },
    popover: {
      title: _i18n.i18n.translate('data.searchSessionIndicator.canceledTitleText', {
        defaultMessage: 'Search session stopped'
      }),
      description: _i18n.i18n.translate('data.searchSessionIndicator.canceledDescriptionText', {
        defaultMessage: 'You are viewing incomplete data'
      }),
      whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.canceledWhenText', {
        defaultMessage: 'Stopped {when}',
        values: {
          when: props.canceledTime ? (0, _moment.default)(props.canceledTime).format(`L @ LTS`) : ''
        }
      }),
      secondaryAction: ViewAllSearchSessionsButton
    }
  }
};
const SearchSessionIndicator = exports.SearchSessionIndicator = /*#__PURE__*/_react.default.forwardRef((props, ref) => {
  var _props$saveDisabled, _popover$whenText;
  const [isPopoverOpen, setIsPopoverOpen] = _react.default.useState(false);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const onOpened = props.onOpened;
  const openPopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(true);
    if (onOpened) onOpened(props.state);
  }, [onOpened, props.state]);
  const onButtonClick = (0, _react.useCallback)(() => {
    if (isPopoverOpen) {
      closePopover();
    } else {
      openPopover();
    }
  }, [isPopoverOpen, openPopover, closePopover]);
  (0, _react.useImperativeHandle)(ref, () => ({
    openPopover: () => {
      openPopover();
    },
    closePopover: () => {
      closePopover();
    }
  }), [openPopover, closePopover]);
  if (!searchSessionIndicatorViewStateToProps[props.state]) return null;
  const {
    button,
    popover
  } = searchSessionIndicatorViewStateToProps[props.state];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: 'downLeft',
    panelPaddingSize: 'm',
    className: "searchSessionIndicator",
    "data-test-subj": 'searchSessionIndicator',
    "data-state": props.state,
    "data-save-disabled": (_props$saveDisabled = props.saveDisabled) !== null && _props$saveDisabled !== void 0 ? _props$saveDisabled : false,
    panelClassName: 'searchSessionIndicator__panel',
    repositionOnScroll: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: button.tooltipText,
      delay: 'long'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: button.color,
      "aria-label": button['aria-label'],
      iconType: button.iconType,
      onClick: onButtonClick
    }))
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "searchSessionIndicatorPopoverContainer"
  }, /*#__PURE__*/_react.default.createElement(_search_sessions_deprecation_message.SearchSessionsDeprecatedWarning, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), props.searchSessionName && props.saveSearchSessionNameFn ? /*#__PURE__*/_react.default.createElement(_components.SearchSessionName, {
    name: props.searchSessionName,
    editName: props.saveSearchSessionNameFn
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's'
  }, /*#__PURE__*/_react.default.createElement("p", null, popover.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs'
  }), (_popover$whenText = popover.whenText) !== null && _popover$whenText !== void 0 && _popover$whenText.call(popover, props) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: 'subdued'
  }, /*#__PURE__*/_react.default.createElement("p", null, popover.whenText(props))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs'
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: 'subdued'
  }, /*#__PURE__*/_react.default.createElement("p", null, popover.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    alignItems: 'center',
    justifyContent: 'flexEnd',
    gutterSize: 's'
  }, popover.primaryAction && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(popover.primaryAction, (0, _extends2.default)({}, props, {
    buttonProps: {
      size: 'xs'
    }
  }))), popover.secondaryAction && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(popover.secondaryAction, (0, _extends2.default)({}, props, {
    buttonProps: {
      size: 'xs',
      flush: 'right'
    }
  }))))));
});

// React.lazy() needs default:
// eslint-disable-next-line import/no-default-export
var _default = exports.default = SearchSessionIndicator;