"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapAndFlattenFilters = void 0;
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _map_filter = require("./map_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const mapAndFlattenFilters = filters => {
  return (0, _lodash.compact)((0, _lodash.flatten)(filters)).map(filter => {
    return (0, _esQuery.migrateFilter)(filter);
  }).map(item => (0, _map_filter.mapFilter)(item));
};
exports.mapAndFlattenFilters = mapAndFlattenFilters;