"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformControlObjectToArray = transformControlObjectToArray;
exports.transformControlProperties = transformControlProperties;
exports.transformControlsSetDefaults = transformControlsSetDefaults;
exports.transformControlsState = void 0;
exports.transformControlsWidthAuto = transformControlsWidthAuto;
var _lodash = require("lodash");
var _common = require("@kbn/controls-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Transform functions for serialized controls state.
 */
const transformControlsState = exports.transformControlsState = (0, _lodash.flow)(JSON.parse, transformControlObjectToArray, transformControlsWidthAuto, transformControlsSetDefaults, transformControlProperties);
function transformControlObjectToArray(controls) {
  return Object.entries(controls).map(([id, control]) => ({
    id,
    ...control
  }));
}

/**
 * Some controls were serialized with width set to 'auto'. This function will transform those controls
 * to have the default width and grow set to true. See @link https://github.com/elastic/kibana/issues/211113.
 */
function transformControlsWidthAuto(controls) {
  return controls.map(control => {
    if (control.width === 'auto') {
      return {
        ...control,
        width: _common.DEFAULT_CONTROL_WIDTH,
        grow: true
      };
    }
    return control;
  });
}

// TODO We may want to remove setting defaults in the future
function transformControlsSetDefaults(controls) {
  return controls.map(control => ({
    grow: _common.DEFAULT_CONTROL_GROW,
    width: _common.DEFAULT_CONTROL_WIDTH,
    ...control
  }));
}
function transformControlProperties(controls) {
  return controls.map(({
    explicitInput,
    id,
    type,
    width,
    grow,
    order
  }) => ({
    controlConfig: explicitInput,
    id,
    grow,
    order,
    type,
    width
  }));
}