"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformControlGroupIn = transformControlGroupIn;
var _lodash = require("lodash");
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformControlGroupIn(controlGroupInput) {
  if (!controlGroupInput) {
    return;
  }
  return (0, _lodash.flow)(transformControlStyle, transformShowApplySelections, transformIgnoreParentSettings, transformPanelsJSON)(controlGroupInput);
}
function transformControlStyle(controlGroupInput) {
  const {
    labelPosition,
    ...restControlGroupInput
  } = controlGroupInput;
  return {
    ...restControlGroupInput,
    controlStyle: labelPosition
  };
}
function transformShowApplySelections(controlGroupInput) {
  const {
    autoApplySelections,
    ...restControlGroupInput
  } = controlGroupInput;
  return {
    ...restControlGroupInput,
    showApplySelections: !autoApplySelections
  };
}
function transformIgnoreParentSettings(controlGroupInput) {
  const {
    ignoreParentSettings,
    ...restControlGroupInput
  } = controlGroupInput;
  return {
    ...restControlGroupInput,
    ignoreParentSettingsJSON: JSON.stringify(ignoreParentSettings)
  };
}
function transformPanelsJSON(controlGroupInput) {
  const {
    controls,
    ...restControlGroupInput
  } = controlGroupInput;
  const updatedControls = Object.fromEntries(controls.map(({
    controlConfig,
    id = (0, _uuid.v4)(),
    ...restOfControl
  }) => {
    return [id, {
      ...restOfControl,
      explicitInput: controlConfig
    }];
  }));
  return {
    ...restControlGroupInput,
    panelsJSON: JSON.stringify(updatedControls)
  };
}