"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardInternalApi = exports.DashboardInternalContext = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DashboardInternalContext = exports.DashboardInternalContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const useDashboardInternalApi = () => {
  const internalApi = (0, _react.useContext)(DashboardInternalContext);
  if (!internalApi) {
    throw new Error('useDashboardInternalApi must be used inside DashboardContext');
  }
  return internalApi;
};
exports.useDashboardInternalApi = useDashboardInternalApi;