"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardApi = exports.DashboardContext = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DashboardContext = exports.DashboardContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const useDashboardApi = () => {
  const api = (0, _react.useContext)(DashboardContext);
  if (!api) {
    throw new Error('useDashboardApi must be used inside DashboardContext');
  }
  return api;
};
exports.useDashboardApi = useDashboardApi;