"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersNotificationPopover = FiltersNotificationPopover;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/presentation-panel-plugin/public");
var _public2 = require("@kbn/unified-search-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public3 = require("@kbn/embeddable-plugin/public");
var _rxjs = require("rxjs");
var _kibana_services = require("../services/kibana_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function FiltersNotificationPopover({
  api
}) {
  var _api$parentApi$dataVi, _api$parentApi, _getViewModeSubject;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [disableEditbutton, setDisableEditButton] = (0, _react.useState)(false);
  const filters = (0, _react.useMemo)(() => {
    var _api$filters$;
    return (_api$filters$ = api.filters$) === null || _api$filters$ === void 0 ? void 0 : _api$filters$.value;
  }, [api]);
  const displayName = _dashboard_actions_strings.dashboardFilterNotificationActionStrings.getDisplayName();
  const executeEditAction = (0, _react.useCallback)(async () => {
    try {
      const action = await _kibana_services.uiActionsService.getAction(_public.ACTION_EDIT_PANEL);
      action.execute({
        embeddable: api,
        trigger: {
          id: _public3.CONTEXT_MENU_TRIGGER
        }
      });
    } catch (error) {
      // eslint-disable-next-line no-console
      console.warn('Unable to execute edit action, Error: ', error.message);
    }
  }, [api]);
  const {
    queryString,
    queryLanguage
  } = (0, _react.useMemo)(() => {
    var _api$query$;
    const query = (_api$query$ = api.query$) === null || _api$query$ === void 0 ? void 0 : _api$query$.value;
    if (!query) return {};
    if ((0, _esQuery.isOfQueryType)(query)) {
      if (typeof query.query === 'string') {
        return {
          queryString: query.query
        };
      } else {
        return {
          queryString: JSON.stringify(query.query, null, 2)
        };
      }
    } else {
      setDisableEditButton(true);
      const language = (0, _esQuery.getAggregateQueryMode)(query);
      return {
        queryString: query[language],
        queryLanguage: language
      };
    }
  }, [api, setDisableEditButton]);
  const [dataViews, parentViewMode] = (0, _presentationPublishing.useBatchedPublishingSubjects)((_api$parentApi$dataVi = (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.dataViews$) !== null && _api$parentApi$dataVi !== void 0 ? _api$parentApi$dataVi : new _rxjs.BehaviorSubject(undefined), (_getViewModeSubject = (0, _presentationPublishing.getViewModeSubject)(api)) !== null && _getViewModeSubject !== void 0 ? _getViewModeSubject : new _rxjs.BehaviorSubject(undefined));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      iconType: 'filter',
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
        if ((0, _presentationPublishing.apiCanLockHoverActions)(api)) {
          api === null || api === void 0 ? void 0 : api.lockHoverActions(!api.hasLockedHoverActions$.value);
        }
      },
      "data-test-subj": `embeddablePanelNotification-${api.uuid}`,
      "aria-label": displayName
    }),
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
      if ((0, _presentationPublishing.apiCanLockHoverActions)(api)) {
        api.lockHoverActions(false);
      }
    },
    anchorPosition: "upCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    css: (0, _react2.css)`
          min-width: 300px;
        `
  }, Boolean(queryString) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _dashboard_actions_strings.dashboardFilterNotificationActionStrings.getQueryTitle(),
    "data-test-subj": 'filtersNotificationModal__query',
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: queryLanguage,
    paddingSize: "s",
    "aria-labelledby": `${_dashboard_actions_strings.dashboardFilterNotificationActionStrings.getQueryTitle()}: ${queryString}`,
    tabIndex: 0 // focus so that keyboard controls will not skip over the code block
  }, queryString)), filters && filters.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _dashboard_actions_strings.dashboardFilterNotificationActionStrings.getFiltersTitle(),
    "data-test-subj": 'filtersNotificationModal__filterItems'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_public2.FilterItems, {
    filters: filters,
    indexPatterns: dataViews !== null && dataViews !== void 0 ? dataViews : [],
    readOnly: true
  })))), !disableEditbutton && parentViewMode === 'edit' && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": 'filtersNotificationModal__editButton',
    size: "s",
    fill: true,
    onClick: executeEditAction
  }, _dashboard_actions_strings.dashboardFilterNotificationActionStrings.getEditButtonTitle())))));
}