"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformMigrationVersion = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const transformMigrationVersion = exports.transformMigrationVersion = {
  // @todo Remove when deferred migrations are publicly available.
  // @ts-expect-error
  deferred: true,
  transform: ({
    migrationVersion,
    ...doc
  }) => {
    var _migrationVersion$doc;
    return {
      ...doc,
      ...(migrationVersion ? {
        typeMigrationVersion: (_migrationVersion$doc = migrationVersion[doc.type]) !== null && _migrationVersion$doc !== void 0 ? _migrationVersion$doc : ''
      } : {})
    };
  }
};