"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CachedResourceObserver = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class CachedResourceObserver {
  constructor() {
    (0, _defineProperty2.default)(this, "loaded", {
      networkOrDisk: 0,
      memory: 0
    });
    (0, _defineProperty2.default)(this, "observer", void 0);
    if (!window.PerformanceObserver) return;
    const cb = entries => {
      const e = entries.getEntries();
      e.forEach(entry => {
        if (entry.initiatorType === 'script' || entry.initiatorType === 'link') {
          // If the resource is fetched from a local cache, or if it is a cross-origin resource, this property returns zero.
          // https://developer.mozilla.org/en-US/docs/Web/API/PerformanceResourceTiming/transferSize
          if (entry.name.indexOf(window.location.host) > -1 && entry.transferSize === 0) {
            this.loaded.memory++;
          } else {
            this.loaded.networkOrDisk++;
          }
        }
      });
    };
    this.observer = new PerformanceObserver(cb);
    this.observer.observe({
      type: 'resource',
      buffered: true
    });
  }
  getCounts() {
    return this.loaded;
  }
  destroy() {
    var _this$observer;
    (_this$observer = this.observer) === null || _this$observer === void 0 ? void 0 : _this$observer.disconnect();
  }
}
exports.CachedResourceObserver = CachedResourceObserver;