"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RollingFileContext = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fs = require("fs");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
var _orderedRolledFileFn = /*#__PURE__*/new WeakMap();
/**
 * Context shared between the rolling file manager, policy and strategy.
 */
class RollingFileContext {
  constructor(filePath) {
    /**
     * The size of the currently opened file.
     */
    (0, _defineProperty2.default)(this, "currentFileSize", 0);
    /**
     * The time the currently opened file was created.
     */
    (0, _defineProperty2.default)(this, "currentFileTime", 0);
    _classPrivateFieldInitSpec(this, _orderedRolledFileFn, void 0);
    this.filePath = filePath;
  }
  refreshFileInfo() {
    try {
      const {
        birthtime,
        size
      } = (0, _fs.statSync)(this.filePath);
      this.currentFileTime = birthtime.getTime();
      this.currentFileSize = size;
    } catch (e) {
      if (e.code !== 'ENOENT') {
        // eslint-disable-next-line no-console
        console.error('[RollingFileAppender] error accessing the log file', e);
      }
      this.currentFileTime = Date.now();
      this.currentFileSize = 0;
    }
  }
  async getOrderedRolledFiles() {
    if (_classPrivateFieldGet(_orderedRolledFileFn, this)) {
      return _classPrivateFieldGet(_orderedRolledFileFn, this).call(this);
    }
    throw new Error('orderedRolledFileFn not registered on the context');
  }
  setOrderedRolledFileFn(fn) {
    _classPrivateFieldSet(_orderedRolledFileFn, this, fn);
  }
}
exports.RollingFileContext = RollingFileContext;