"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SkipToMainContent = exports.ScreenReaderRouteAnnouncements = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_BRAND = 'Elastic'; // This may need to be DRYed out with https://github.com/elastic/kibana/blob/main/src/core/packages/rendering/server-internal/src/views/template.tsx#L35
const SEPARATOR = ' - ';
const ScreenReaderRouteAnnouncements = ({
  breadcrumbs$,
  customBranding$,
  appId$
}) => {
  var _useObservable;
  const [routeTitle, setRouteTitle] = (0, _react.useState)('');
  const branding = ((_useObservable = (0, _useObservable2.default)(customBranding$)) === null || _useObservable === void 0 ? void 0 : _useObservable.pageTitle) || DEFAULT_BRAND;
  const breadcrumbs = (0, _useObservable2.default)(breadcrumbs$, []);
  (0, _react.useEffect)(() => {
    if (breadcrumbs.length) {
      const breadcrumbText = [];

      // Reverse the breadcrumb title order and ensure we only pick up valid strings
      [...breadcrumbs].reverse().forEach(breadcrumb => {
        if (typeof breadcrumb.text === 'string') breadcrumbText.push(breadcrumb.text);
      });
      breadcrumbText.push(branding);
      setRouteTitle(breadcrumbText.join(SEPARATOR));
    } else {
      // Don't announce anything during loading states
      setRouteTitle('');
    }
  }, [breadcrumbs, branding]);

  // 1. Canvas dynamically updates breadcrumbs *and* page title/history on every name onChange,
  // which leads to focus fighting if this is enabled
  const appId = (0, _useObservable2.default)(appId$);
  const disableFocusForApps = ['canvas'];
  const focusRegionOnTextChange = !disableFocusForApps.includes(appId || '');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderLive, {
    focusRegionOnTextChange: focusRegionOnTextChange
  }, routeTitle);
};
exports.ScreenReaderRouteAnnouncements = ScreenReaderRouteAnnouncements;
const fallbackContentQueries = ['main',
// Ideal target for all plugins using KibanaPageTemplate
'[role="main"]',
// Fallback for plugins using deprecated EuiPageContent
'.kbnAppWrapper' // Last-ditch fallback for all plugins regardless of page template
];
const SkipToMainContent = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkipLink, {
    position: "fixed",
    destinationId: "" // TODO: Potentially allow this to be customizable per-plugin
    ,
    fallbackDestination: fallbackContentQueries,
    overrideLinkBehavior: true,
    href: "" // Render a button
  }, _i18n.i18n.translate('core.ui.skipToMainButton', {
    defaultMessage: 'Skip to main content'
  }));
};
exports.SkipToMainContent = SkipToMainContent;