"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderBreadcrumbs = HeaderBreadcrumbs;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function HeaderBreadcrumbs({
  breadcrumbs$
}) {
  const breadcrumbs = (0, _useObservable.default)(breadcrumbs$, []);
  let crumbs = breadcrumbs;
  if (breadcrumbs.length === 0) {
    crumbs = [{
      text: 'Kibana'
    }];
  }
  crumbs = crumbs.map((breadcrumb, i) => {
    const isLast = i === breadcrumbs.length - 1;
    const {
      deepLinkId,
      ...rest
    } = breadcrumb;
    return {
      ...rest,
      href: isLast ? undefined : breadcrumb.href,
      onClick: isLast ? undefined : breadcrumb.onClick,
      'data-test-subj': (0, _classnames.default)('breadcrumb', deepLinkId && `breadcrumb-deepLinkId-${deepLinkId}`, breadcrumb['data-test-subj'], i === 0 && 'first', isLast && 'last')
    };
  });
  // Modify last breadcrumb's text color to comply with A11y contrast ratio (AA)
  // https://github.com/elastic/kibana/issues/214597
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderBreadcrumbs, {
    breadcrumbs: crumbs,
    max: 10,
    "data-test-subj": "breadcrumbs",
    css: ({
      euiTheme,
      colorMode
    }) => (0, _react.css)`
        [class*='euiBreadcrumb-application'] .euiBreadcrumb__content:not(.euiLink) {
          color: ${(0, _eui.makeHighContrastColor)(colorMode === 'DARK' ? (0, _eui.shade)(euiTheme.colors.darkestShade, 0.2) : (0, _eui.tint)(euiTheme.colors.darkestShade, 0.2))(colorMode === 'DARK' ? (0, _eui.shade)(euiTheme.colors.darkestShade, 0.7) : (0, _eui.tint)(euiTheme.colors.darkestShade, 0.85))};
        }
      `
  });
}