"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.confirmDeleteControl = exports.confirmDeleteAllControls = void 0;
var _i18n = require("@kbn/i18n");
var _kibana_services = require("../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const openConfirmDeleteModal = all => _kibana_services.coreServices.overlays.openConfirm(_i18n.i18n.translate('controls.controlGroup.management.delete.sub', {
  defaultMessage: 'Controls are not recoverable once removed.'
}), {
  confirmButtonText: _i18n.i18n.translate('controls.controlGroup.management.delete.confirm', {
    defaultMessage: 'Delete'
  }),
  cancelButtonText: _i18n.i18n.translate('controls.controlGroup.management.delete.cancel', {
    defaultMessage: 'Cancel'
  }),
  title: all ? _i18n.i18n.translate('controls.controlGroup.management.delete.deleteAllTitle', {
    defaultMessage: 'Delete all controls?'
  }) : _i18n.i18n.translate('controls.controlGroup.management.delete.deleteTitle', {
    defaultMessage: 'Delete control?'
  }),
  buttonColor: 'danger'
});
const confirmDeleteControl = () => openConfirmDeleteModal(false);
exports.confirmDeleteControl = confirmDeleteControl;
const confirmDeleteAllControls = () => openConfirmDeleteModal(true);
exports.confirmDeleteAllControls = confirmDeleteAllControls;