"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autoCompleteEntitiesValidationConfig = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const autoCompleteEntitiesValidationConfig = exports.autoCompleteEntitiesValidationConfig = {
  query: _configSchema.schema.object({
    indices: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    fields: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    templates: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    dataStreams: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    /**
     * Comma separated list of indices for mappings retrieval.
     */
    fieldsIndices: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    validate: payload => {
      if (Object.keys(payload).length === 0) {
        return 'The request must contain at least one of the following parameters: indices, fields, templates, dataStreams.';
      }
    }
  })
};