"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleParamComponent = void 0;
var _shared_component = require("./shared_component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SimpleParamComponent extends _shared_component.SharedComponent {
  constructor(name, parent) {
    super(name, parent);
  }
  match(token, context, editor) {
    const result = super.match(token, context, editor);
    result.context_values = result.context_values || {};
    result.context_values[this.name] = token;
    return result;
  }
}
exports.SimpleParamComponent = SimpleParamComponent;