"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldAutocompleteComponent = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _services = require("../../../services");
var _list_component = require("./list_component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function FieldGenerator(context) {
  return _lodash.default.map((0, _services.getAutocompleteInfo)().getEntityProvider(_services.ENTITIES.FIELDS, context), function (field) {
    return {
      name: field.name,
      meta: field.type
    };
  });
}
class FieldAutocompleteComponent extends _list_component.ListComponent {
  constructor(name, parent, multiValued) {
    super(name, FieldGenerator, parent, multiValued);
  }
  validateTokens(tokens) {
    if (!this.multiValued && tokens.length > 1) {
      return false;
    }
    return !_lodash.default.find(tokens, function (token) {
      return token.match(/[^\w.?*]/);
    });
  }
  getDefaultTermMeta() {
    return 'field';
  }
  getContextKey() {
    return 'fields';
  }
}
exports.FieldAutocompleteComponent = FieldAutocompleteComponent;