"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = exports.initialValue = void 0;
var _immer = require("immer");
var _function = require("fp-ts/lib/function");
var _services = require("../../services");
var _constants = require("../containers/main/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const initialValue = exports.initialValue = (0, _immer.produce)({
  ready: false,
  settings: _services.DEFAULT_SETTINGS,
  currentTextObject: null,
  currentView: _constants.SHELL_TAB_ID,
  restoreRequestFromHistory: null,
  fileToImport: null
}, _function.identity);
const reducer = (state, action) => (0, _immer.produce)(state, draft => {
  if (action.type === 'setInputEditor') {
    if (action.payload) {
      draft.ready = true;
    }
    return;
  }
  if (action.type === 'updateSettings') {
    draft.settings = action.payload;
    return;
  }
  if (action.type === 'setCurrentTextObject') {
    draft.currentTextObject = action.payload;
    return;
  }
  if (action.type === 'setRequestToRestore') {
    // Store the request and change the current view to the shell
    draft.restoreRequestFromHistory = action.payload;
    draft.currentView = _constants.SHELL_TAB_ID;
    return;
  }
  if (action.type === 'setCurrentView') {
    draft.currentView = action.payload;
    return;
  }
  if (action.type === 'clearRequestToRestore') {
    draft.restoreRequestFromHistory = null;
    return;
  }
  if (action.type === 'setFileToImport') {
    draft.fileToImport = action.payload;
    return;
  }
  return draft;
});
exports.reducer = reducer;