"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _contexts = require("../contexts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const styles = {
  // Hide the external svg icon for the link given that we have a custom icon for it.
  // Also remove the the hover effect on the action icon since it's a bit distracting.
  listItem: (0, _react2.css)`
    .euiListGroupItem__button {
      > svg {
        display: none;
      }
    }

    .euiButtonIcon:hover {
      background: transparent;
    }
  `
};
const HelpPopover = ({
  button,
  isOpen,
  closePopover,
  resetTour
}) => {
  const {
    docLinks
  } = (0, _contexts.useServicesContext)();
  const listItems = (0, _react.useMemo)(() => [{
    label: _i18n.i18n.translate('console.helpPopover.aboutConsoleLabel', {
      defaultMessage: 'About Console'
    }),
    href: docLinks.console.guide,
    target: '_blank',
    css: styles.listItem,
    extraAction: {
      iconType: 'popout',
      href: docLinks.console.guide,
      target: '_blank',
      alwaysShow: true,
      'aria-label': _i18n.i18n.translate('console.helpPopover.aboutConsoleButtonAriaLabel', {
        defaultMessage: 'About Console link'
      })
    }
  }, {
    label: _i18n.i18n.translate('console.helpPopover.aboutQueryDSLLabel', {
      defaultMessage: 'About Query DSL'
    }),
    href: docLinks.query.queryDsl,
    target: '_blank',
    css: styles.listItem,
    extraAction: {
      iconType: 'popout',
      href: docLinks.query.queryDsl,
      target: '_blank',
      alwaysShow: true,
      'aria-label': _i18n.i18n.translate('console.helpPopover.aboutQueryDSLButtonAriaLabel', {
        defaultMessage: 'About QueryDSL link'
      })
    }
  }, {
    label: _i18n.i18n.translate('console.helpPopover.rerunTourLabel', {
      defaultMessage: 'Re-run feature tour'
    }),
    css: styles.listItem,
    onClick: resetTour,
    extraAction: {
      iconType: 'refresh',
      alwaysShow: true,
      onClick: resetTour,
      'data-test-subj': 'consoleRerunTourButton',
      'aria-label': _i18n.i18n.translate('console.helpPopover.rerunTourButtonAriaLabel', {
        defaultMessage: 'Re-run feature tour button'
      })
    }
  }], [docLinks, resetTour]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isOpen,
    closePopover: closePopover,
    anchorPosition: "downRight",
    buffer: 4,
    ownFocus: false,
    panelPaddingSize: "none",
    "data-test-subj": "consoleHelpPopover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    hasBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('console.helpPopover.title', {
    defaultMessage: 'Elastic Console'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: {
      width: 300
    },
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('console.helpPopover.description', {
    defaultMessage: 'Console is an interactive UI for calling Elasticsearch and Kibana APIs and viewing their responses. Search your data, manage settings, and more, using Query DSL and REST API syntax.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    listItems: listItems,
    color: "primary",
    size: "s"
  }));
};
exports.HelpPopover = HelpPopover;