"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineGetBenchmarksRoute = exports.PACKAGE_POLICY_SAVED_OBJECT_TYPE = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../common/constants");
var _v = require("../../../common/types/benchmarks/v1");
var _v2 = require("./v1");
var _v3 = require("./v2");
var _latest = require("../../../common/types/latest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PACKAGE_POLICY_SAVED_OBJECT_TYPE = exports.PACKAGE_POLICY_SAVED_OBJECT_TYPE = 'ingest-package-policies';
const defineGetBenchmarksRoute = router => router.versioned.get({
  access: 'internal',
  path: _constants.BENCHMARKS_ROUTE_PATH,
  security: {
    authz: {
      requiredPrivileges: ['cloud-security-posture-read']
    }
  }
}).addVersion({
  version: '1',
  validate: {
    request: {
      query: _v.benchmarksQueryParamsSchema
    }
  }
}, async (context, request, response) => {
  const cspContext = await context.csp;
  try {
    const cspBenchmarks = await (0, _v2.getBenchmarks)(cspContext.soClient, cspContext.packagePolicyService, request.query, cspContext.agentPolicyService, cspContext.agentService, cspContext.logger);
    return response.ok({
      body: cspBenchmarks
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch benchmarks ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
}).addVersion({
  version: '2',
  validate: {
    response: {
      200: {
        body: _latest.benchmarkResponseSchema
      }
    }
  }
}, async (context, request, response) => {
  const cspContext = await context.csp;
  const esClient = cspContext.esClient.asCurrentUser;
  try {
    const cspBenchmarks = await (0, _v3.getBenchmarks)(esClient, cspContext.soClient, cspContext.encryptedSavedObjects, cspContext.logger);
    return response.ok({
      body: cspBenchmarks
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch benchmarks ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineGetBenchmarksRoute = defineGetBenchmarksRoute;