"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Vulnerabilities = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _use_csp_setup_status_api = require("@kbn/cloud-security-posture/src/hooks/use_csp_setup_status_api");
var _use_data_view = require("@kbn/cloud-security-posture/src/hooks/use_data_view");
var _eui = require("@elastic/eui");
var _test_subjects = require("./test_subjects");
var _constants = require("../../../common/constants");
var _no_vulnerabilities_states = require("../../components/no_vulnerabilities_states");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _latest_vulnerabilities_container = require("./latest_vulnerabilities_container");
var _data_view_context = require("../../common/contexts/data_view_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Vulnerabilities = () => {
  var _setupStatus$vuln_mgm;
  const dataViewQuery = (0, _use_data_view.useDataView)(_constants.CDR_VULNERABILITIES_DATA_VIEW_ID_PREFIX);
  const getSetupStatus = (0, _use_csp_setup_status_api.useCspSetupStatusApi)();
  const setupStatus = getSetupStatus.data;
  const hasFindings = !!(setupStatus !== null && setupStatus !== void 0 && setupStatus.hasVulnerabilitiesFindings) || (setupStatus === null || setupStatus === void 0 ? void 0 : (_setupStatus$vuln_mgm = setupStatus.vuln_mgmt) === null || _setupStatus$vuln_mgm === void 0 ? void 0 : _setupStatus$vuln_mgm.status) === 'indexed';
  if (!hasFindings) return /*#__PURE__*/_react.default.createElement(_no_vulnerabilities_states.NoVulnerabilitiesStates, null);
  const dataViewContextValue = {
    dataView: dataViewQuery.data,
    dataViewRefetch: dataViewQuery.refetch,
    dataViewIsRefetching: dataViewQuery.isRefetching
  };
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: dataViewQuery
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_subjects.VULNERABILITIES_PAGE
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _cloudSecurityPosture.findingsNavigation.vulnerabilities.path,
    render: () => /*#__PURE__*/_react.default.createElement(_data_view_context.DataViewContext.Provider, {
      value: dataViewContextValue
    }, /*#__PURE__*/_react.default.createElement(_latest_vulnerabilities_container.LatestVulnerabilitiesContainer, null))
  }))));
};
exports.Vulnerabilities = Vulnerabilities;