"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVectorScoreList = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getVectorScoreList = vectorBaseScore => {
  const result = [];
  const v2Vector = vectorBaseScore === null || vectorBaseScore === void 0 ? void 0 : vectorBaseScore.V2Vector;
  const v2Score = vectorBaseScore === null || vectorBaseScore === void 0 ? void 0 : vectorBaseScore.V2Score;
  const v3Vector = vectorBaseScore === null || vectorBaseScore === void 0 ? void 0 : vectorBaseScore.V3Vector;
  const v3Score = vectorBaseScore === null || vectorBaseScore === void 0 ? void 0 : vectorBaseScore.V3Score;
  if (v2Vector) {
    result.push({
      version: '2.0',
      vector: v2Vector,
      score: v2Score
    });
  }
  if (v3Vector) {
    result.push({
      version: '3.0',
      vector: v3Vector,
      score: v3Score
    });
  }
  return result;
};
exports.getVectorScoreList = getVectorScoreList;