"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspLoadingState = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _full_size_centered_page = require("./full_size_centered_page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Keep this component lean as it is part of the main app bundle
const CspLoadingState = ({
  children,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, {
    "data-test-subj": rest['data-test-subj']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), children);
};
exports.CspLoadingState = CspLoadingState;