"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAppearance = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _userProfileComponents = require("@kbn/user-profile-components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAppearance = ({
  uiSettingsClient,
  defaultColorMode
}) => {
  // If a value is set in kibana.yml (uiSettings.overrides.theme:darkMode)
  // we don't allow the user to change the theme color.
  const valueSetInKibanaConfig = uiSettingsClient.isOverridden('theme:darkMode');
  const {
    userProfileData,
    isLoading,
    update,
    userProfileLoaded
  } = (0, _userProfileComponents.useUpdateUserProfile)({
    notificationSuccess: {
      title: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearance.successNotificationTitle', {
        defaultMessage: 'Appearance settings updated'
      }),
      pageReloadText: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearance.successNotificationText', {
        defaultMessage: 'Reload the page to see the changes'
      })
    },
    pageReloadChecker: (prev, next) => {
      var _prev$userSettings, _next$userSettings;
      return (prev === null || prev === void 0 ? void 0 : (_prev$userSettings = prev.userSettings) === null || _prev$userSettings === void 0 ? void 0 : _prev$userSettings.darkMode) !== ((_next$userSettings = next.userSettings) === null || _next$userSettings === void 0 ? void 0 : _next$userSettings.darkMode);
    }
  });
  const {
    userSettings: {
      darkMode: colorModeUserProfile = defaultColorMode
    } = {}
  } = userProfileData !== null && userProfileData !== void 0 ? userProfileData : {
    userSettings: {}
  };
  const [colorMode, setColorMode] = (0, _react.useState)(colorModeUserProfile);
  const [initialColorModeValue, setInitialColorModeValue] = (0, _react.useState)(colorModeUserProfile);
  const onChange = (0, _react.useCallback)(({
    colorMode: updatedColorMode
  }, persist) => {
    if (isLoading) {
      return;
    }

    // optimistic update
    if (updatedColorMode) {
      setColorMode(updatedColorMode);
    }

    // TODO: here we will update the contrast when available

    if (!persist) {
      return;
    }
    return update({
      userSettings: {
        darkMode: updatedColorMode
      }
    });
  }, [isLoading, update]);
  (0, _react.useEffect)(() => {
    setColorMode(colorModeUserProfile);
  }, [colorModeUserProfile]);
  (0, _react.useEffect)(() => {
    if (userProfileLoaded) {
      var _userProfileData$user;
      const storedValue = userProfileData === null || userProfileData === void 0 ? void 0 : (_userProfileData$user = userProfileData.userSettings) === null || _userProfileData$user === void 0 ? void 0 : _userProfileData$user.darkMode;
      if (storedValue) {
        setInitialColorModeValue(storedValue);
      }
    }
  }, [userProfileData, userProfileLoaded]);
  return {
    isVisible: valueSetInKibanaConfig ? false : Boolean(userProfileData),
    setColorMode,
    colorMode,
    onChange,
    isLoading,
    initialColorModeValue
  };
};
exports.useAppearance = useAppearance;