"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicySettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _helpers = require("../../../common/utils/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _control_settings = require("../control_settings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicySettings = ({
  policy,
  onChange
}) => {
  const [policyHasErrors, setPolicyHasErrors] = (0, _react.useState)(false);
  const controlInput = (0, _helpers.getInputFromPolicy)(policy, _constants.INPUT_CONTROL);
  const controlEnabled = !!(controlInput !== null && controlInput !== void 0 && controlInput.enabled);
  const onToggleEnabled = (0, _react.useCallback)(e => {
    if (controlInput) {
      controlInput.enabled = e.target.checked;
      onChange({
        isValid: !policyHasErrors,
        updatedPolicy: {
          ...policy
        }
      });
    }
  }, [controlInput, onChange, policyHasErrors, policy]);
  const onNameChange = (0, _react.useCallback)(event => {
    const name = event.currentTarget.value;
    onChange({
      isValid: !policyHasErrors,
      updatedPolicy: {
        ...policy,
        name
      }
    });
  }, [onChange, policyHasErrors, policy]);
  const onDescriptionChange = (0, _react.useCallback)(event => {
    const description = event.currentTarget.value;
    onChange({
      isValid: !policyHasErrors,
      updatedPolicy: {
        ...policy,
        description
      }
    });
  }, [onChange, policyHasErrors, policy]);
  const onPolicyChange = (0, _react.useCallback)(props => {
    setPolicyHasErrors(!props.isValid);
    onChange(props);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.name,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "name",
    value: policy.name,
    onChange: onNameChange,
    "data-test-subj": "cloud-defend-policy-name"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.description,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    name: "name",
    value: policy.description,
    onChange: onDescriptionChange,
    "data-test-subj": "cloud-defend-policy-description",
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "cloud-defend-controltoggle",
    label: i18n.enableControl,
    checked: controlEnabled,
    onChange: onToggleEnabled
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, i18n.enableControlHelp))))), controlEnabled && /*#__PURE__*/_react.default.createElement(_control_settings.ControlSettings, {
    "data-test-subj": "cloud-defend-controlsettings",
    policy: policy,
    onChange: onPolicyChange
  }));
};
exports.PolicySettings = PolicySettings;