"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    size,
    border
  } = euiTheme;
  return (0, _react.useMemo)(() => {
    const accordion = {
      borderRadius: border.radius.medium,
      border: border.thin,
      '> .euiAccordion__triggerWrapper': {
        padding: size.m
      }
    };
    const conditionsBadge = {
      display: 'inline'
    };
    const verticalDivider = {
      display: 'inline-block',
      verticalAlign: 'middle',
      width: '1px',
      height: '20px',
      border: border.thin,
      borderRight: 0,
      borderTop: 0,
      borderBottom: 0,
      marginLeft: size.base,
      marginRight: size.base
    };
    return {
      accordion,
      conditionsBadge,
      verticalDivider
    };
  }, [border.radius.medium, border.thin, size.base, size.m]);
};
exports.useStyles = useStyles;