"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = _configSchema.schema.object({
  enabled: (0, _configSchema.offeringBasedSchema)({
    // cloud_data_migration is disabled in serverless; refer to the serverless.yml file as the source of truth
    // We take this approach in order to have a central place (serverless.yml) to view disabled plugins across Kibana
    serverless: _configSchema.schema.boolean({
      defaultValue: true
    })
  })
});
const config = exports.config = {
  schema: configSchema
};