"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorUserActionBuilder = void 0;
var _constants = require("../../../../common/constants");
var _domain = require("../../../../common/types/domain");
var _abstract_builder = require("../abstract_builder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConnectorUserActionBuilder extends _abstract_builder.UserActionBuilder {
  build(args) {
    const action = _domain.UserActionActions.update;
    const parameters = this.buildCommonUserAction({
      ...args,
      action,
      valueKey: 'connector',
      value: this.extractConnectorId(args.payload.connector),
      type: _domain.UserActionTypes.connector,
      connectorId: args.payload.connector.id
    });
    const getMessage = id => `User changed the case connector to id: ${args.payload.connector.id} for case id: ${args.caseId} - user action id: ${id}`;
    const eventDetails = {
      getMessage,
      action,
      descriptiveAction: 'case_user_action_update_case_connector',
      savedObjectId: args.caseId,
      savedObjectType: _constants.CASE_SAVED_OBJECT
    };
    return {
      parameters,
      eventDetails
    };
  }
}
exports.ConnectorUserActionBuilder = ConnectorUserActionBuilder;