"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActionAuditLogger = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionsToEcsType = {
  add: 'change',
  delete: 'deletion',
  create: 'creation',
  push_to_service: 'change',
  update: 'change'
};
class UserActionAuditLogger {
  constructor(auditLogger) {
    this.auditLogger = auditLogger;
  }
  log(event, storedUserActionId) {
    if (!event) {
      return;
    }
    this.auditLogger.log({
      message: event.getMessage(storedUserActionId),
      event: {
        action: event.descriptiveAction,
        category: ['database'],
        type: [actionsToEcsType[event.action]],
        outcome: 'success'
      },
      kibana: {
        saved_object: {
          type: event.savedObjectType,
          id: event.savedObjectId
        }
      }
    });
  }
}
exports.UserActionAuditLogger = UserActionAuditLogger;